/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <iiexc.h>

// ----------
// ITableImpl
// ----------

// public members

inline INumber&
ITableImpl::
AddMod (INumber& index1, INumber index2) const
{ return (index1 = 1 + ((index1 + index2 - 1) % ivAllocatedElements));
}

inline IBoolean
ITableImpl::
CanAdd (INumber n) const
{ return (ivNumberOfElements + n <= ivAllocatedElements);
}

inline INumber&
ITableImpl::
DecMod (INumber& index) const
{ IASSERT (index > 0)
  if (--index == 0)
    index = ivAllocatedElements;
  return index;
}

inline INumber&
ITableImpl::
IncMod (INumber& index) const
{ IASSERT (index <= ivAllocatedElements)
  if (index == ivAllocatedElements)
    index = 0;
  return ++index;
}

inline void*
ITableImpl::
NodeAtIndex (INumber index) const
{ IASSERT (index > 0 && index <= ivAllocatedElements)
  return (char*)ivNodes + ivNodeSize * (index - 1);
}

inline INumber
ITableImpl::
Pos (INumber index) const
{ return index >= ivFirst ?
         index - ivFirst + 1:
         ivAllocatedElements - (ivFirst - index) + 1;
}
