/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIVCLLCT_H
#define _IIVCLLCT_H

#include <iiglobal.h>
#include <istdntfy.hpp>

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

class ICursor;

class ICursorImpl;

template <class Element>
class IVCollectionEventData {
public:

           IVCollectionEventData
                            (ICursor const&, Element const* = 0);

  ICursor const&
           cursor           () const;

  Element const*const
           element          () const;

protected:

private:

  ICursor const*
           ivCursor;

  Element const*
           ivElement;


};

class IVCollectionImpl : public IStandardNotifier {

  typedef  IStandardNotifier Inherited;

public:

  static
  INotificationId const
  IC_IMPORTB addId,
  IC_IMPORTB modifyId,
  IC_IMPORTB removeId,
  IC_IMPORTB replaceId;

  // for backward compatibility
  static
  INotificationId const
  IC_IMPORTB addedId,
  IC_IMPORTB modifiedId,
  IC_IMPORTB removedId,
  IC_IMPORTB replacedId;

          ~IVCollectionImpl ();

  INotifier&
           DisableNotification
                            ();

  INotifier&
           EnableNotification
                            (IBoolean = true);

  IBoolean HasObservers     () const;

  IBoolean IsEnabledForNotification
                            () const;

protected:

           IVCollectionImpl ();

  void     NotifyOfAddAt    (ICursorImpl const&);

  void     NotifyOfModification
                            ();

  void     NotifyOfRemoveAt (ICursorImpl const&);

  void     NotifyOfReplaceAt
                            (ICursorImpl const&, void const* = 0);

private:


};

typedef IVCollectionImpl IVCollection;

#include <iivcllct.inl>

#pragma info (restore)
#pragma pack ()

#endif
