/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ---------------------
// IVCollectionEventData
// ---------------------

// public members

template <class Element>
inline
IVCollectionEventData <Element>::
IVCollectionEventData (ICursor const& cursor,
                       Element const* element)
: ivCursor (&cursor), ivElement (element)
{
}

template <class Element>
inline ICursor const&
IVCollectionEventData <Element>::
cursor () const
{ return *ivCursor;
}

template <class Element>
inline Element const*const
IVCollectionEventData <Element>::
element () const
{ return ivElement;
}

// ----------------
// IVCollectionImpl
// ----------------

// public members

inline INotifier&
IVCollectionImpl::
DisableNotification ()
{ return disableNotification ();
}

inline INotifier&
IVCollectionImpl::
EnableNotification (IBoolean enable)
{ return enableNotification (enable);
}

inline IBoolean
IVCollectionImpl::
IsEnabledForNotification () const
{ return isEnabledForNotification ();
}

inline IBoolean
IVCollectionImpl::
HasObservers () const
{ return ! observerList ().isEmpty ();
}

#pragma info (restore)
#pragma pack ()
