/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

// ---
// IVKeyBagImpl
// ---

// public members

template <class VInherited>
IVKeyBagImpl <VInherited>::
IVKeyBagImpl (Ops& ops, INumber numberOfElements)
: VInherited (ops, numberOfElements)
{
}

template <class VInherited>
IVKeyBagImpl <VInherited>::
IVKeyBagImpl
  (Ops& ops, IVKeyBagImpl <VInherited> const& collection)
: VInherited (ops, collection)
{
}

template <class VInherited>
IBoolean
IVKeyBagImpl <VInherited>::
Add (void const* element, ICursorImpl& cursor)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  IBoolean hasBeenAdded = VInherited::Add (element, cursor);
  EnableNotification (isEnabled);
  if (hasBeenAdded && HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
  return hasBeenAdded;
}

template <class VInherited>
void
IVKeyBagImpl <VInherited>::
AddAllFrom (IACollectionImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::AddAllFrom (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
IBoolean
IVKeyBagImpl <VInherited>::
AddOrReplaceElementWithKey (void const* element, ICursorImpl& cursor)
{ IBoolean hasBeenAdded = false;
  if (VInherited::LocateElementWithKey (Key (element), cursor)) {
    if (HasObservers ()) {
#if defined (ICLCC_COMPAT_IVB)
      NotifyOfRemoveAt (cursor); // to be removed in a future release
#else
      NotifyOfReplaceAt (cursor, element);
#endif
    }
    VInherited::ReplaceAt (cursor, element);
#if defined (ICLCC_COMPAT_IVB)
    if (HasObservers ()) {
      NotifyOfAddAt (cursor); // to be removed in a future release
    }
#endif
  }
  else {
    hasBeenAdded = VInherited::Add (element, cursor);
    if (HasObservers ()) {
      NotifyOfAddAt (cursor);
    }
  }
  return hasBeenAdded;
}

template <class VInherited>
void
IVKeyBagImpl <VInherited>::
Copy (IACollectionImpl const& collection)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  VInherited::Copy (collection);
  EnableNotification (isEnabled);
  if (HasObservers ()) {
    NotifyOfModification ();
  }
}

template <class VInherited>
IBoolean
IVKeyBagImpl <VInherited>::
LocateOrAddElementWithKey (void const* key, ICursorImpl& cursor)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  IBoolean hasBeenLocated =
    VInherited::LocateOrAddElementWithKey (key, cursor);
  EnableNotification (isEnabled);
  if (!hasBeenLocated && HasObservers ()) {
    NotifyOfAddAt (cursor);
  }
  return hasBeenLocated;
}

template <class VInherited>
INumber
IVKeyBagImpl <VInherited>::
RemoveAll ()
{ INumber result = VInherited::RemoveAll ();
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
INumber
IVKeyBagImpl <VInherited>::
RemoveAll (IPredFunc predFunc, void* addArg)
{ INumber result = VInherited::RemoveAll (predFunc, addArg);
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
INumber
IVKeyBagImpl <VInherited>::
RemoveAllElementsWithKey (void const* key)
{ IBoolean isEnabled = IsEnabledForNotification ();
  DisableNotification ();
  INumber result = VInherited::RemoveAllElementsWithKey (key);
  EnableNotification (isEnabled);
  if (result > 0 && HasObservers ()) {
    NotifyOfModification ();
  }
  return result;
}

template <class VInherited>
void
IVKeyBagImpl <VInherited>::
RemoveAt (ICursorImpl& cursor)
{ if (HasObservers ()) {
    NotifyOfRemoveAt (cursor);
  }
  VInherited::RemoveAt (cursor);
}

template <class VInherited>
IBoolean
IVKeyBagImpl <VInherited>::
RemoveElementWithKey (void const* key)
{ if (HasObservers () &&
      LocateElementWithKey (key, CursorOf (*this))) {
    NotifyOfRemoveAt (CursorOf (*this));
  }
  return VInherited::RemoveElementWithKey (key);
}

template <class VInherited>
void
IVKeyBagImpl <VInherited>::
ReplaceAt (ICursorImpl const& cursor, void const* element)
{ if (HasObservers ()) {
#if defined (ICLCC_COMPAT_IVB)
    NotifyOfRemoveAt (cursor); // to be removed in a future release
#else
    NotifyOfReplaceAt (cursor, element);
#endif
  }
  VInherited::ReplaceAt (cursor, element);
#if defined (ICLCC_COMPAT_IVB)
  if (HasObservers ()) {
    NotifyOfAddAt (cursor); // to be removed in a future release
  }
#endif
}

template <class VInherited>
IBoolean
IVKeyBagImpl <VInherited>::
ReplaceElementWithKey (void const* element, ICursorImpl& cursor)
{ if (HasObservers ()) {
#if defined (ICLCC_COMPAT_IVB)
    NotifyOfRemoveAt (cursor); // to be removed in a future release
#else
    NotifyOfReplaceAt (cursor, element);
#endif
  }
  IBoolean hasBeenReplaced =
    VInherited::ReplaceElementWithKey (element, cursor);
#if defined (ICLCC_COMPAT_IVB)
  if (HasObservers ()) {
    NotifyOfAddAt (cursor); // to be removed in a future release
  }
#endif
  return hasBeenReplaced;
}

#pragma info (restore)
#pragma pack ()
