/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIVSB_H
#define _IIVSB_H

#include <iiasb.h>

#pragma SOMAsDefault (off)

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

template <class VInherited>
class IVSortedBagImpl : public VInherited {
public:

  typedef  VInherited::Ops Ops;

           IVSortedBagImpl
                            (Ops&, INumber);

           IVSortedBagImpl
                            (Ops&, IVSortedBagImpl
                                    <VInherited> const&);

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAntivalence   (IASortedBagImpl const&,
                             IASortedBagImpl const&);

  void     AddDifference    (IASortedBagImpl const&,
                             IASortedBagImpl const&);

  void     AddIntersection  (IASortedBagImpl const&,
                             IASortedBagImpl const&);

  void     AddUnion         (IASortedBagImpl const&,
                             IASortedBagImpl const&);

  void     Antivalence      (IASortedBagImpl const&);

  void     Copy             (IACollectionImpl const&);

  void     Difference       (IASortedBagImpl const&);

  void     Intersection     (IASortedBagImpl const&);

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  IBoolean Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  void     Union            (IASortedBagImpl const&);

protected:

private:


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iivsb.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
