/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IIVSM_H
#define _IIVSM_H

#include <iiasm.h>

#pragma SOMAsDefault (off)

#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

template <class VInherited>
class IVSortedMapImpl : public VInherited {
public:

  typedef  VInherited::Ops Ops;

           IVSortedMapImpl
                            (Ops&, INumber);

           IVSortedMapImpl
                            (Ops&, IVSortedMapImpl
                                    <VInherited> const&);

  IBoolean Add              (void const*, ICursorImpl&);

  void     AddAllFrom       (IACollectionImpl const&);

  void     AddAntivalence   (IASortedMapImpl const&,
                             IASortedMapImpl const&);

  void     AddDifference    (IASortedMapImpl const&,
                             IASortedMapImpl const&);

  void     AddIntersection  (IASortedMapImpl const&,
                             IASortedMapImpl const&);

  void     AddUnion         (IASortedMapImpl const&,
                             IASortedMapImpl const&);

  void     Antivalence      (IASortedMapImpl const&);

  IBoolean AddOrReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Copy             (IACollectionImpl const&);

  void     Difference       (IASortedMapImpl const&);

  void     Intersection     (IASortedMapImpl const&);

  IBoolean LocateOrAdd      (void const*, ICursorImpl&);

  IBoolean LocateOrAddElementWithKey
                            (void const*, ICursorImpl&);

  IBoolean Remove           (void const*);

  INumber  RemoveAll        ();

  INumber  RemoveAll        (IPredFunc, void*);

  INumber  RemoveAllElementsWithKey
                            (void const*);

  INumber  RemoveAllOccurrences
                            (void const*);

  void     RemoveAt         (ICursorImpl&);

  IBoolean RemoveElementWithKey
                            (void const*);

  void     RemoveAtPosition (IPosition);

  void     RemoveFirst      ();

  void     RemoveLast       ();

  void     ReplaceAt        (ICursorImpl const&, void const*);

  IBoolean ReplaceElementWithKey
                            (void const*, ICursorImpl&);

  void     Union            (IASortedMapImpl const&);

protected:

private:


};

#pragma SOMAsDefault (pop)

#if ! defined (__TEMPINC__)
#include <iivsm.c>
#endif

#pragma info (restore)
#pragma pack ()

#endif
