/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKBDIL_H
#define _IKBDIL_H

#include <iakb.h>
#include <iickb.h>
#include <iivkb.h>
#include <iikbdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeyBagAsDilTable;

template <class Element, class Key, class ElementOps>
class IGKeyBagAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGKeyBagAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeyBagAsDilTableCursor
                            (IGKeyBagAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeyBagAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeyBagAsDilTable :
  public IAKeyBag <Element, Key> {
protected:

  typedef  IGKeyBagAsDilTable <Element, Key, ElementOps> Self;

  typedef  IKeyBagAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeyBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeyBagAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeyBagAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeyBagAsDilTableCursor
            <Element, Key, ElementOps> Cursor;


           IGKeyBagAsDilTable
                            (INumber = 100);

           IGKeyBagAsDilTable
                            (IGKeyBagAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeyBagAsDilTable <Element, Key, ElementOps>&
           operator=        (IGKeyBagAsDilTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeyBagAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeyBagAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeyBagAsDilTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeyBagAsDilTable :
  public IGKeyBagAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeyBagAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeyBagAsDilTable <Element, Key> Self;

#define IKeyBagAsDilTableTypedef(Element, Key)\
  typedef  IKeyBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeyBagAsDilTable
                            (INumber = 100);


protected:

           IKeyBagAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeyBagAsDilTable :
  public IGKeyBagAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGKeyBagAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeyBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeyBagImpl
            <IVKeyBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeyBagAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeyBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeyBagAsDilTableTypedef (Element, Key, ElementOps);

public:

           IVGKeyBagAsDilTable
                            (INumber = 100);


protected:

           IVGKeyBagAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeyBagAsDilTable :
  public IVGKeyBagAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeyBagAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeyBagAsDilTable <Element, Key> Self;

#define IVKeyBagAsDilTableTypedef(Element, Key)\
  typedef  IVKeyBagAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeyBagAsDilTable
                            (INumber = 100);


protected:

           IVKeyBagAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ikbdil.inl>

#pragma info (restore)
#pragma pack ()

#endif
