/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeyBagAsDilTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsDilTableCursor <Element, Key, ElementOps>::
IGKeyBagAsDilTableCursor
  (IGKeyBagAsDilTable
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeyBagAsDilTableCursor <Element, Key, ElementOps>&
IGKeyBagAsDilTableCursor <Element, Key, ElementOps>::
operator=
  (IGKeyBagAsDilTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsDilTableCursor <Element, Key, ElementOps>::
IGKeyBagAsDilTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGKeyBagAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsDilTable <Element, Key, ElementOps>::
IGKeyBagAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsDilTable <Element, Key, ElementOps>::
IGKeyBagAsDilTable
  (IGKeyBagAsDilTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeyBagAsDilTable <Element, Key, ElementOps>&
IGKeyBagAsDilTable <Element, Key, ElementOps>::
operator= (IGKeyBagAsDilTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsDilTable <Element, Key, ElementOps>::
IGKeyBagAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeyBagAsDilTable
 <Element, Key, ElementOps>::Implementation&
IGKeyBagAsDilTable <Element, Key, ElementOps>::
ImplOf (IGKeyBagAsDilTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeyBagAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IKeyBagAsDilTable <Element, Key>::
IKeyBagAsDilTable (INumber numberOfElements)
: IGKeyBagAsDilTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeyBagAsDilTable <Element, Key>::
IKeyBagAsDilTable (PureImplementation& impl)
: IGKeyBagAsDilTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeyBagAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeyBagAsDilTable <Element, Key, ElementOps>::
IVGKeyBagAsDilTable (INumber numberOfElements)
: IGKeyBagAsDilTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeyBagAsDilTable <Element, Key, ElementOps>::
IVGKeyBagAsDilTable (PureImplementation& impl)
: IGKeyBagAsDilTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeyBagAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IVKeyBagAsDilTable <Element, Key>::
IVKeyBagAsDilTable (INumber numberOfElements)
: IVGKeyBagAsDilTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeyBagAsDilTable <Element, Key>::
IVKeyBagAsDilTable (PureImplementation& impl)
: IVGKeyBagAsDilTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
