/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeyBagAsHshTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsHshTableCursor <Element, Key, ElementOps>::
IGKeyBagAsHshTableCursor
  (IGKeyBagAsHshTable
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeyBagAsHshTableCursor <Element, Key, ElementOps>&
IGKeyBagAsHshTableCursor <Element, Key, ElementOps>::
operator=
  (IGKeyBagAsHshTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsHshTableCursor <Element, Key, ElementOps>::
IGKeyBagAsHshTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGKeyBagAsHshTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsHshTable <Element, Key, ElementOps>::
IGKeyBagAsHshTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsHshTable <Element, Key, ElementOps>::
IGKeyBagAsHshTable
  (IGKeyBagAsHshTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeyBagAsHshTable <Element, Key, ElementOps>&
IGKeyBagAsHshTable <Element, Key, ElementOps>::
operator= (IGKeyBagAsHshTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeyBagAsHshTable <Element, Key, ElementOps>::
IGKeyBagAsHshTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeyBagAsHshTable
 <Element, Key, ElementOps>::Implementation&
IGKeyBagAsHshTable <Element, Key, ElementOps>::
ImplOf (IGKeyBagAsHshTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeyBagAsHshTable
// ---

// public members

template <class Element, class Key>
inline
IKeyBagAsHshTable <Element, Key>::
IKeyBagAsHshTable (INumber numberOfElements)
: IGKeyBagAsHshTable
   <Element, Key, IKEHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeyBagAsHshTable <Element, Key>::
IKeyBagAsHshTable (PureImplementation& impl)
: IGKeyBagAsHshTable
   <Element, Key, IKEHOps <Element, Key> > (impl)
{
}

// ---
// IVGKeyBagAsHshTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeyBagAsHshTable <Element, Key, ElementOps>::
IVGKeyBagAsHshTable (INumber numberOfElements)
: IGKeyBagAsHshTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeyBagAsHshTable <Element, Key, ElementOps>::
IVGKeyBagAsHshTable (PureImplementation& impl)
: IGKeyBagAsHshTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeyBagAsHshTable
// ---

// public members

template <class Element, class Key>
inline
IVKeyBagAsHshTable <Element, Key>::
IVKeyBagAsHshTable (INumber numberOfElements)
: IVGKeyBagAsHshTable
   <Element, Key, IKEHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeyBagAsHshTable <Element, Key>::
IVKeyBagAsHshTable (PureImplementation& impl)
: IVGKeyBagAsHshTable
   <Element, Key, IKEHOps <Element, Key> > (impl)
{
}
