#ifndef _IKEYEVT_
  #define _IKEYEVT_
/*******************************************************************************
* FILE NAME: ikeyevt.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IKeyboardEvent                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>

class IString;
class IKeyboardHandler;
class IKeyboardEventPrivateData;

#pragma pack(4)

class IKeyboardEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------ Constructors --------------------------------*/
  IKeyboardEvent     ( const IEvent& event );
virtual
 ~IKeyboardEvent     ( );

/*--------------------------------- Testing ----------------------------------*/
Boolean
  isCharacter        ( ) const,
  isScanCode         ( ) const,
  isVirtual          ( ) const,
  isUpTransition     ( ) const,
  isRepeat           ( ) const,
  isShiftDown        ( ) const,
  isCtrlDown         ( ) const,
  isAltDown          ( ) const,
  isForComposite     ( ) const,
  isComposite        ( ) const,
  isInvalidComposite ( ) const;
#ifndef IC_WIN_FLAGNOP
Boolean
  isUncombined       ( ) const;
#endif

/*-------------------------------- Accessors ---------------------------------*/
char
  character          ( ) const;
IString
  mixedCharacter     ( ) const;
unsigned long
  scanCode           ( ) const;

enum VirtualKey
{
  esc, tab, backTab, space, backSpace, enter, newLine,
  shift, ctrl, altGraf, insert, deleteKey, home, end,
  pageUp, pageDown, left, right, up, down,
  capsLock, numLock, scrollLock, pause,
#ifndef IC_WIN_FLAGNOP
  sysRq,
#endif
  breakKey,
  f2, f3, f4, f5, f6, f7, f8, f9, f11, f12,
  f13, f14, f15, f16, f17, f18, f19, f20, f21, f22, f23, f24,
  button1, button2, button3, other
  , f1, f10
};

VirtualKey
  virtualKey         ( ) const;

unsigned long
  repeatCount        ( ) const;


protected:
/*------------------------------ Implementation ------------------------------*/
static const unsigned long
#ifndef IC_WIN_FLAGNOP
  IC_IMPORTU ulCharacterFlag,
  IC_IMPORTU ulScanCodeFlag,
  IC_IMPORTU ulVirtualFlag,
  IC_IMPORTU ulRepeatFlag,
  IC_IMPORTU ulUncombinedFlag,
  IC_IMPORTU ulShiftFlag,
  IC_IMPORTU ulCtrlFlag,
  IC_IMPORTU ulForCompositeFlag,
  IC_IMPORTU ulCompositeFlag,
  IC_IMPORTU ulInvalidCompositeFlag,
#endif
  IC_IMPORTU ulUpTransitionFlag,
  IC_IMPORTU ulAltFlag;

private:
friend IKeyboardHandler;
Boolean
  fValidComposite,
  fInvalidComposite;
IKeyboardEventPrivateData
 *pData;
}; // IKeyboardEvent

#pragma pack()

/*----------------------------- Inline Functions -----------------------------*/
  #include <ikeyevt.inl>

#endif /* _IKEYEVT_ */
