#ifndef _IKEYEVT_INL_
#define _IKEYEVT_INL_ 0
/*******************************************************************************
* FILE NAME: ikeyevt.inl                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   This file contains the definition of the inline functions for the          *
*   class(es) declared in ikeyevt.hpp.                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#ifndef _IKEYEVT_
  #undef  _IKEYEVT_INL_
  #define _IKEYEVT_INL_ 1
  #include <ikeyevt.hpp>
#endif

#if _IKEYEVT_INL_
  #define inline
#endif

/*------------------------------ IKeyboardEvent ------------------------------*/
inline IBase::Boolean  IKeyboardEvent::isScanCode ( ) const
{
  return ((isVirtual() && parameter2().char3()) ? true : false);
}
inline IBase::Boolean  IKeyboardEvent::isUpTransition ( ) const
{
  return ((parameter2().asUnsignedLong() & ulUpTransitionFlag ) ? true : false);
}
inline IBase::Boolean  IKeyboardEvent::isRepeat ( ) const
{
  return ((parameter2().number1() > 1 ) ? true : false);
}
inline IBase::Boolean  IKeyboardEvent::isAltDown ( ) const
{
  return ((parameter2().asUnsignedLong() & ulAltFlag ) ? true : false);
}
inline IBase::Boolean  IKeyboardEvent::isComposite ( ) const
{
  return fValidComposite;
}
inline IBase::Boolean  IKeyboardEvent::isInvalidComposite ( ) const
{
  return fInvalidComposite;
}

#endif // _IKEYEVT_INL_
