/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKS_H
#define _IKS_H

#include <iaks.h>
#include <iicks.h>
#include <iivks.h>
#include <iiksavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySet;

template <class Element, class Key, class ElementOps>
class IGKeySetCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGKeySet
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetCursor
                            (IGKeySet
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySet :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySet <Element, Key, ElementOps> Self;

  typedef  IKeySetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySetCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySet
                            (INumber = 100);

           IGKeySet
                            (IGKeySet
                              <
                               Element, Key, ElementOps> const&);

  IGKeySet <Element, Key, ElementOps>&
           operator=        (IGKeySet
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySet
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySet
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySet :
  public IGKeySet
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySet
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySet <Element, Key> Self;

#define IKeySetTypedef(Element, Key)\
  typedef  IKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySet
                            (INumber = 100);


protected:

           IKeySet
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySet :
  public IGKeySet
          <Element, Key, ElementOps > {

  typedef  IVGKeySet
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetTypedef (Element, Key, ElementOps);

public:

           IVGKeySet
                            (INumber = 100);


protected:

           IVGKeySet
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySet :
  public IVGKeySet
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySet
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySet <Element, Key> Self;

#define IVKeySetTypedef(Element, Key)\
  typedef  IVKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySet
                            (INumber = 100);


protected:

           IVKeySet
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iks.inl>

#pragma info (restore)
#pragma pack ()

#endif
