/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySetCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySetCursor <Element, Key, ElementOps>::
IGKeySetCursor
  (IGKeySet
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySetCursor <Element, Key, ElementOps>&
IGKeySetCursor <Element, Key, ElementOps>::
operator=
  (IGKeySetCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySetCursor <Element, Key, ElementOps>::
IGKeySetCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGKeySet
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySet <Element, Key, ElementOps>::
IGKeySet (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySet <Element, Key, ElementOps>::
IGKeySet
  (IGKeySet
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySet <Element, Key, ElementOps>&
IGKeySet <Element, Key, ElementOps>::
operator= (IGKeySet
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySet <Element, Key, ElementOps>::
IGKeySet (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySet
 <Element, Key, ElementOps>::Implementation&
IGKeySet <Element, Key, ElementOps>::
ImplOf (IGKeySet
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySet
// ---

// public members

template <class Element, class Key>
inline
IKeySet <Element, Key>::
IKeySet (INumber numberOfElements)
: IGKeySet
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySet <Element, Key>::
IKeySet (PureImplementation& impl)
: IGKeySet
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySet
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySet <Element, Key, ElementOps>::
IVGKeySet (INumber numberOfElements)
: IGKeySet
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySet <Element, Key, ElementOps>::
IVGKeySet (PureImplementation& impl)
: IGKeySet
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySet
// ---

// public members

template <class Element, class Key>
inline
IVKeySet <Element, Key>::
IVKeySet (INumber numberOfElements)
: IVGKeySet
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySet <Element, Key>::
IVKeySet (PureImplementation& impl)
: IVGKeySet
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
