/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSAVL_H
#define _IKSAVL_H

#include <iaks.h>
#include <iicks.h>
#include <iivks.h>
#include <iiksavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySetAsAvlTree;

template <class Element, class Key, class ElementOps>
class IGKeySetAsAvlTreeCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGKeySetAsAvlTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetAsAvlTreeCursor
                            (IGKeySetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsAvlTreeCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetAsAvlTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetAsAvlTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySetAsAvlTree :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySetAsAvlTree <Element, Key, ElementOps> Self;

  typedef  IKeySetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetAsAvlTreeTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySetAsAvlTreeCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySetAsAvlTree
                            (INumber = 100);

           IGKeySetAsAvlTree
                            (IGKeySetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsAvlTree <Element, Key, ElementOps>&
           operator=        (IGKeySetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySetAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetAsAvlTreeCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySetAsAvlTree :
  public IGKeySetAsAvlTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySetAsAvlTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySetAsAvlTree <Element, Key> Self;

#define IKeySetAsAvlTreeTypedef(Element, Key)\
  typedef  IKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySetAsAvlTree
                            (INumber = 100);


protected:

           IKeySetAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySetAsAvlTree :
  public IGKeySetAsAvlTree
          <Element, Key, ElementOps > {

  typedef  IVGKeySetAsAvlTree
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetAsAvlTreeTypedef (Element, Key, ElementOps);

public:

           IVGKeySetAsAvlTree
                            (INumber = 100);


protected:

           IVGKeySetAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySetAsAvlTree :
  public IVGKeySetAsAvlTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySetAsAvlTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySetAsAvlTree <Element, Key> Self;

#define IVKeySetAsAvlTreeTypedef(Element, Key)\
  typedef  IVKeySetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySetAsAvlTree
                            (INumber = 100);


protected:

           IVKeySetAsAvlTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iksavl.inl>

#pragma info (restore)
#pragma pack ()

#endif
