/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySetAsAvlTreeCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsAvlTreeCursor <Element, Key, ElementOps>::
IGKeySetAsAvlTreeCursor
  (IGKeySetAsAvlTree
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsAvlTreeCursor <Element, Key, ElementOps>&
IGKeySetAsAvlTreeCursor <Element, Key, ElementOps>::
operator=
  (IGKeySetAsAvlTreeCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsAvlTreeCursor <Element, Key, ElementOps>::
IGKeySetAsAvlTreeCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGKeySetAsAvlTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsAvlTree <Element, Key, ElementOps>::
IGKeySetAsAvlTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsAvlTree <Element, Key, ElementOps>::
IGKeySetAsAvlTree
  (IGKeySetAsAvlTree
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsAvlTree <Element, Key, ElementOps>&
IGKeySetAsAvlTree <Element, Key, ElementOps>::
operator= (IGKeySetAsAvlTree
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsAvlTree <Element, Key, ElementOps>::
IGKeySetAsAvlTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsAvlTree
 <Element, Key, ElementOps>::Implementation&
IGKeySetAsAvlTree <Element, Key, ElementOps>::
ImplOf (IGKeySetAsAvlTree
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySetAsAvlTree
// ---

// public members

template <class Element, class Key>
inline
IKeySetAsAvlTree <Element, Key>::
IKeySetAsAvlTree (INumber numberOfElements)
: IGKeySetAsAvlTree
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySetAsAvlTree <Element, Key>::
IKeySetAsAvlTree (PureImplementation& impl)
: IGKeySetAsAvlTree
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySetAsAvlTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySetAsAvlTree <Element, Key, ElementOps>::
IVGKeySetAsAvlTree (INumber numberOfElements)
: IGKeySetAsAvlTree
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySetAsAvlTree <Element, Key, ElementOps>::
IVGKeySetAsAvlTree (PureImplementation& impl)
: IGKeySetAsAvlTree
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySetAsAvlTree
// ---

// public members

template <class Element, class Key>
inline
IVKeySetAsAvlTree <Element, Key>::
IVKeySetAsAvlTree (INumber numberOfElements)
: IVGKeySetAsAvlTree
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySetAsAvlTree <Element, Key>::
IVKeySetAsAvlTree (PureImplementation& impl)
: IVGKeySetAsAvlTree
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
