/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSB_H
#define _IKSB_H

#include <iaksb.h>
#include <iicksb.h>
#include <iivksb.h>
#include <iiksblst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySortedBag;

template <class Element, class Key, class ElementOps>
class IGKeySortedBagCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGKeySortedBag
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedBagCursor
                            (IGKeySortedBag
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBagCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedBagCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedBagCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySortedBag :
  public IAKeySortedBag <Element, Key> {
protected:

  typedef  IGKeySortedBag <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedBagTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedBagTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySortedBagCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySortedBag
                            (INumber = 100);

           IGKeySortedBag
                            (IGKeySortedBag
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBag <Element, Key, ElementOps>&
           operator=        (IGKeySortedBag
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySortedBag
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedBag
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedBagCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySortedBag :
  public IGKeySortedBag
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedBag
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySortedBag <Element, Key> Self;

#define IKeySortedBagTypedef(Element, Key)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySortedBag
                            (INumber = 100);


protected:

           IKeySortedBag
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySortedBag :
  public IGKeySortedBag
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedBag
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedBagTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedBagTypedef (Element, Key, ElementOps);

public:

           IVGKeySortedBag
                            (INumber = 100);


protected:

           IVGKeySortedBag
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySortedBag :
  public IVGKeySortedBag
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedBag
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySortedBag <Element, Key> Self;

#define IVKeySortedBagTypedef(Element, Key)\
  typedef  IVKeySortedBagAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySortedBag
                            (INumber = 100);


protected:

           IVKeySortedBag
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iksb.inl>

#pragma info (restore)
#pragma pack ()

#endif
