/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySetAsBstTreeCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsBstTreeCursor <Element, Key, ElementOps>::
IGKeySetAsBstTreeCursor
  (IGKeySetAsBstTree
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsBstTreeCursor <Element, Key, ElementOps>&
IGKeySetAsBstTreeCursor <Element, Key, ElementOps>::
operator=
  (IGKeySetAsBstTreeCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsBstTreeCursor <Element, Key, ElementOps>::
IGKeySetAsBstTreeCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGKeySetAsBstTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsBstTree <Element, Key, ElementOps>::
IGKeySetAsBstTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsBstTree <Element, Key, ElementOps>::
IGKeySetAsBstTree
  (IGKeySetAsBstTree
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsBstTree <Element, Key, ElementOps>&
IGKeySetAsBstTree <Element, Key, ElementOps>::
operator= (IGKeySetAsBstTree
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsBstTree <Element, Key, ElementOps>::
IGKeySetAsBstTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsBstTree
 <Element, Key, ElementOps>::Implementation&
IGKeySetAsBstTree <Element, Key, ElementOps>::
ImplOf (IGKeySetAsBstTree
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySetAsBstTree
// ---

// public members

template <class Element, class Key>
inline
IKeySetAsBstTree <Element, Key>::
IKeySetAsBstTree (INumber numberOfElements)
: IGKeySetAsBstTree
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySetAsBstTree <Element, Key>::
IKeySetAsBstTree (PureImplementation& impl)
: IGKeySetAsBstTree
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySetAsBstTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySetAsBstTree <Element, Key, ElementOps>::
IVGKeySetAsBstTree (INumber numberOfElements)
: IGKeySetAsBstTree
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySetAsBstTree <Element, Key, ElementOps>::
IVGKeySetAsBstTree (PureImplementation& impl)
: IGKeySetAsBstTree
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySetAsBstTree
// ---

// public members

template <class Element, class Key>
inline
IVKeySetAsBstTree <Element, Key>::
IVKeySetAsBstTree (INumber numberOfElements)
: IVGKeySetAsBstTree
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySetAsBstTree <Element, Key>::
IVKeySetAsBstTree (PureImplementation& impl)
: IVGKeySetAsBstTree
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
