/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSBTAB_H
#define _IKSBTAB_H

#include <iaksb.h>
#include <iicksb.h>
#include <iivksb.h>
#include <iiksbtab.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsTable;

template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsTableCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGKeySortedBagAsTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedBagAsTableCursor
                            (IGKeySortedBagAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBagAsTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedBagAsTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedBagAsTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySortedBagAsTable :
  public IAKeySortedBag <Element, Key> {
protected:

  typedef  IGKeySortedBagAsTable <Element, Key, ElementOps> Self;

  typedef  IKeySortedBagAsTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedBagImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedBagAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedBagAsTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySortedBagAsTableCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySortedBagAsTable
                            (INumber = 100);

           IGKeySortedBagAsTable
                            (IGKeySortedBagAsTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedBagAsTable <Element, Key, ElementOps>&
           operator=        (IGKeySortedBagAsTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySortedBagAsTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedBagAsTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedBagAsTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySortedBagAsTable :
  public IGKeySortedBagAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedBagAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySortedBagAsTable <Element, Key> Self;

#define IKeySortedBagAsTableTypedef(Element, Key)\
  typedef  IKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySortedBagAsTable
                            (INumber = 100);


protected:

           IKeySortedBagAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySortedBagAsTable :
  public IGKeySortedBagAsTable
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedBagAsTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySortedBagImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedBagImpl
            <IVKeySortedBagImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedBagAsTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedBagAsTableTypedef (Element, Key, ElementOps);

public:

           IVGKeySortedBagAsTable
                            (INumber = 100);


protected:

           IVGKeySortedBagAsTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySortedBagAsTable :
  public IVGKeySortedBagAsTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedBagAsTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySortedBagAsTable <Element, Key> Self;

#define IVKeySortedBagAsTableTypedef(Element, Key)\
  typedef  IVKeySortedBagAsTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySortedBagAsTable
                            (INumber = 100);


protected:

           IVKeySortedBagAsTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iksbtab.inl>

#pragma info (restore)
#pragma pack ()

#endif
