/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySortedBagAsTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsTableCursor <Element, Key, ElementOps>::
IGKeySortedBagAsTableCursor
  (IGKeySortedBagAsTable
    <Element, Key, ElementOps> const& collection)
: IOrderedCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedBagAsTableCursor <Element, Key, ElementOps>&
IGKeySortedBagAsTableCursor <Element, Key, ElementOps>::
operator=
  (IGKeySortedBagAsTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsTableCursor <Element, Key, ElementOps>::
IGKeySortedBagAsTableCursor (ICursorImpl* impl)
: IOrderedCursor <Element> (impl)
{
}

// ---
// IGKeySortedBagAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsTable <Element, Key, ElementOps>::
IGKeySortedBagAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsTable <Element, Key, ElementOps>::
IGKeySortedBagAsTable
  (IGKeySortedBagAsTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedBagAsTable <Element, Key, ElementOps>&
IGKeySortedBagAsTable <Element, Key, ElementOps>::
operator= (IGKeySortedBagAsTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySortedBagAsTable <Element, Key, ElementOps>::
IGKeySortedBagAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySortedBagAsTable
 <Element, Key, ElementOps>::Implementation&
IGKeySortedBagAsTable <Element, Key, ElementOps>::
ImplOf (IGKeySortedBagAsTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySortedBagAsTable
// ---

// public members

template <class Element, class Key>
inline
IKeySortedBagAsTable <Element, Key>::
IKeySortedBagAsTable (INumber numberOfElements)
: IGKeySortedBagAsTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySortedBagAsTable <Element, Key>::
IKeySortedBagAsTable (PureImplementation& impl)
: IGKeySortedBagAsTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySortedBagAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedBagAsTable <Element, Key, ElementOps>::
IVGKeySortedBagAsTable (INumber numberOfElements)
: IGKeySortedBagAsTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySortedBagAsTable <Element, Key, ElementOps>::
IVGKeySortedBagAsTable (PureImplementation& impl)
: IGKeySortedBagAsTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySortedBagAsTable
// ---

// public members

template <class Element, class Key>
inline
IVKeySortedBagAsTable <Element, Key>::
IVKeySortedBagAsTable (INumber numberOfElements)
: IVGKeySortedBagAsTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySortedBagAsTable <Element, Key>::
IVKeySortedBagAsTable (PureImplementation& impl)
: IVGKeySortedBagAsTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
