/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSDIL_H
#define _IKSDIL_H

#include <iaks.h>
#include <iicks.h>
#include <iivks.h>
#include <iiksdil.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySetAsDilTable;

template <class Element, class Key, class ElementOps>
class IGKeySetAsDilTableCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGKeySetAsDilTable
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySetAsDilTableCursor
                            (IGKeySetAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsDilTableCursor <Element, Key, ElementOps>&
           operator=        (IGKeySetAsDilTableCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySetAsDilTableCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySetAsDilTable :
  public IAKeySet <Element, Key> {
protected:

  typedef  IGKeySetAsDilTable <Element, Key, ElementOps> Self;

  typedef  IKeySetAsDilTableImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySetAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySetAsDilTableTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySetAsDilTableCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySetAsDilTable
                            (INumber = 100);

           IGKeySetAsDilTable
                            (IGKeySetAsDilTable
                              <
                               Element, Key, ElementOps> const&);

  IGKeySetAsDilTable <Element, Key, ElementOps>&
           operator=        (IGKeySetAsDilTable
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySetAsDilTable
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySetAsDilTable
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySetAsDilTableCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySetAsDilTable :
  public IGKeySetAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySetAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySetAsDilTable <Element, Key> Self;

#define IKeySetAsDilTableTypedef(Element, Key)\
  typedef  IKeySetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySetAsDilTable
                            (INumber = 100);


protected:

           IKeySetAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySetAsDilTable :
  public IGKeySetAsDilTable
          <Element, Key, ElementOps > {

  typedef  IVGKeySetAsDilTable
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySetImpl
            <IVKeySetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySetAsDilTableTypedef(Element, Key, ElementOps)\
  typedef  IKeySetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySetAsDilTableTypedef (Element, Key, ElementOps);

public:

           IVGKeySetAsDilTable
                            (INumber = 100);


protected:

           IVGKeySetAsDilTable
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySetAsDilTable :
  public IVGKeySetAsDilTable
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySetAsDilTable
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySetAsDilTable <Element, Key> Self;

#define IVKeySetAsDilTableTypedef(Element, Key)\
  typedef  IVKeySetAsDilTableOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySetAsDilTable
                            (INumber = 100);


protected:

           IVKeySetAsDilTable
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iksdil.inl>

#pragma info (restore)
#pragma pack ()

#endif
