/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySetAsDilTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsDilTableCursor <Element, Key, ElementOps>::
IGKeySetAsDilTableCursor
  (IGKeySetAsDilTable
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsDilTableCursor <Element, Key, ElementOps>&
IGKeySetAsDilTableCursor <Element, Key, ElementOps>::
operator=
  (IGKeySetAsDilTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsDilTableCursor <Element, Key, ElementOps>::
IGKeySetAsDilTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGKeySetAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsDilTable <Element, Key, ElementOps>::
IGKeySetAsDilTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsDilTable <Element, Key, ElementOps>::
IGKeySetAsDilTable
  (IGKeySetAsDilTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsDilTable <Element, Key, ElementOps>&
IGKeySetAsDilTable <Element, Key, ElementOps>::
operator= (IGKeySetAsDilTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsDilTable <Element, Key, ElementOps>::
IGKeySetAsDilTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsDilTable
 <Element, Key, ElementOps>::Implementation&
IGKeySetAsDilTable <Element, Key, ElementOps>::
ImplOf (IGKeySetAsDilTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySetAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IKeySetAsDilTable <Element, Key>::
IKeySetAsDilTable (INumber numberOfElements)
: IGKeySetAsDilTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySetAsDilTable <Element, Key>::
IKeySetAsDilTable (PureImplementation& impl)
: IGKeySetAsDilTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySetAsDilTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySetAsDilTable <Element, Key, ElementOps>::
IVGKeySetAsDilTable (INumber numberOfElements)
: IGKeySetAsDilTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySetAsDilTable <Element, Key, ElementOps>::
IVGKeySetAsDilTable (PureImplementation& impl)
: IGKeySetAsDilTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySetAsDilTable
// ---

// public members

template <class Element, class Key>
inline
IVKeySetAsDilTable <Element, Key>::
IVKeySetAsDilTable (INumber numberOfElements)
: IVGKeySetAsDilTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySetAsDilTable <Element, Key>::
IVKeySetAsDilTable (PureImplementation& impl)
: IVGKeySetAsDilTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
