/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySetAsHshTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsHshTableCursor <Element, Key, ElementOps>::
IGKeySetAsHshTableCursor
  (IGKeySetAsHshTable
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsHshTableCursor <Element, Key, ElementOps>&
IGKeySetAsHshTableCursor <Element, Key, ElementOps>::
operator=
  (IGKeySetAsHshTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsHshTableCursor <Element, Key, ElementOps>::
IGKeySetAsHshTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGKeySetAsHshTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsHshTable <Element, Key, ElementOps>::
IGKeySetAsHshTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsHshTable <Element, Key, ElementOps>::
IGKeySetAsHshTable
  (IGKeySetAsHshTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsHshTable <Element, Key, ElementOps>&
IGKeySetAsHshTable <Element, Key, ElementOps>::
operator= (IGKeySetAsHshTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsHshTable <Element, Key, ElementOps>::
IGKeySetAsHshTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsHshTable
 <Element, Key, ElementOps>::Implementation&
IGKeySetAsHshTable <Element, Key, ElementOps>::
ImplOf (IGKeySetAsHshTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySetAsHshTable
// ---

// public members

template <class Element, class Key>
inline
IKeySetAsHshTable <Element, Key>::
IKeySetAsHshTable (INumber numberOfElements)
: IGKeySetAsHshTable
   <Element, Key, IKEHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySetAsHshTable <Element, Key>::
IKeySetAsHshTable (PureImplementation& impl)
: IGKeySetAsHshTable
   <Element, Key, IKEHOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySetAsHshTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySetAsHshTable <Element, Key, ElementOps>::
IVGKeySetAsHshTable (INumber numberOfElements)
: IGKeySetAsHshTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySetAsHshTable <Element, Key, ElementOps>::
IVGKeySetAsHshTable (PureImplementation& impl)
: IGKeySetAsHshTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySetAsHshTable
// ---

// public members

template <class Element, class Key>
inline
IVKeySetAsHshTable <Element, Key>::
IVKeySetAsHshTable (INumber numberOfElements)
: IVGKeySetAsHshTable
   <Element, Key, IKEHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySetAsHshTable <Element, Key>::
IVKeySetAsHshTable (PureImplementation& impl)
: IVGKeySetAsHshTable
   <Element, Key, IKEHOps <Element, Key> > (impl)
{
}
