/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSS_H
#define _IKSS_H

#include <iakss.h>
#include <iickss.h>
#include <iivkss.h>
#include <iikssavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySortedSet;

template <class Element, class Key, class ElementOps>
class IGKeySortedSetCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGKeySortedSet
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedSetCursor
                            (IGKeySortedSet
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedSetCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySortedSet :
  public IAKeySortedSet <Element, Key> {
protected:

  typedef  IGKeySortedSet <Element, Key, ElementOps> Self;

  typedef  IKeySortedSetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedSetTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedSetTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySortedSetCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySortedSet
                            (INumber = 100);

           IGKeySortedSet
                            (IGKeySortedSet
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSet <Element, Key, ElementOps>&
           operator=        (IGKeySortedSet
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySortedSet
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedSet
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedSetCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySortedSet :
  public IGKeySortedSet
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedSet
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySortedSet <Element, Key> Self;

#define IKeySortedSetTypedef(Element, Key)\
  typedef  IKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySortedSet
                            (INumber = 100);


protected:

           IKeySortedSet
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySortedSet :
  public IGKeySortedSet
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedSet
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedSetImpl
            <IVKeySortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedSetTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedSetTypedef (Element, Key, ElementOps);

public:

           IVGKeySortedSet
                            (INumber = 100);


protected:

           IVGKeySortedSet
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySortedSet :
  public IVGKeySortedSet
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedSet
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySortedSet <Element, Key> Self;

#define IVKeySortedSetTypedef(Element, Key)\
  typedef  IVKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySortedSet
                            (INumber = 100);


protected:

           IVKeySortedSet
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ikss.inl>

#pragma info (restore)
#pragma pack ()

#endif
