/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSSAVL_H
#define _IKSSAVL_H

#include <iakss.h>
#include <iickss.h>
#include <iivkss.h>
#include <iikssavl.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsAvlTree;

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsAvlTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGKeySortedSetAsAvlTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedSetAsAvlTreeCursor
                            (IGKeySortedSetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsAvlTreeCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsAvlTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedSetAsAvlTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsAvlTree :
  public IAKeySortedSet <Element, Key> {
protected:

  typedef  IGKeySortedSetAsAvlTree <Element, Key, ElementOps> Self;

  typedef  IKeySortedSetAsAvlTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedSetAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedSetAsAvlTreeTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySortedSetAsAvlTreeCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySortedSetAsAvlTree
                            (INumber = 100);

           IGKeySortedSetAsAvlTree
                            (IGKeySortedSetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsAvlTree <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySortedSetAsAvlTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedSetAsAvlTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedSetAsAvlTreeCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySortedSetAsAvlTree :
  public IGKeySortedSetAsAvlTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedSetAsAvlTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySortedSetAsAvlTree <Element, Key> Self;

#define IKeySortedSetAsAvlTreeTypedef(Element, Key)\
  typedef  IKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySortedSetAsAvlTree
                            (INumber = 100);


protected:

           IKeySortedSetAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySortedSetAsAvlTree :
  public IGKeySortedSetAsAvlTree
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedSetAsAvlTree
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedSetImpl
            <IVKeySortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedSetAsAvlTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedSetAsAvlTreeTypedef (Element, Key, ElementOps);

public:

           IVGKeySortedSetAsAvlTree
                            (INumber = 100);


protected:

           IVGKeySortedSetAsAvlTree
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySortedSetAsAvlTree :
  public IVGKeySortedSetAsAvlTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedSetAsAvlTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySortedSetAsAvlTree <Element, Key> Self;

#define IVKeySortedSetAsAvlTreeTypedef(Element, Key)\
  typedef  IVKeySortedSetAsAvlTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySortedSetAsAvlTree
                            (INumber = 100);


protected:

           IVKeySortedSetAsAvlTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ikssavl.inl>

#pragma info (restore)
#pragma pack ()

#endif
