/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSSBST_H
#define _IKSSBST_H

#include <iakss.h>
#include <iickss.h>
#include <iivkss.h>
#include <iikssbst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsBstTree;

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsBstTreeCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGKeySortedSetAsBstTree
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedSetAsBstTreeCursor
                            (IGKeySortedSetAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsBstTreeCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsBstTreeCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedSetAsBstTreeCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsBstTree :
  public IAKeySortedSet <Element, Key> {
protected:

  typedef  IGKeySortedSetAsBstTree <Element, Key, ElementOps> Self;

  typedef  IKeySortedSetAsBstTreeImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedSetAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedSetAsBstTreeTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySortedSetAsBstTreeCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySortedSetAsBstTree
                            (INumber = 100);

           IGKeySortedSetAsBstTree
                            (IGKeySortedSetAsBstTree
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsBstTree <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsBstTree
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySortedSetAsBstTree
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedSetAsBstTree
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedSetAsBstTreeCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySortedSetAsBstTree :
  public IGKeySortedSetAsBstTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedSetAsBstTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySortedSetAsBstTree <Element, Key> Self;

#define IKeySortedSetAsBstTreeTypedef(Element, Key)\
  typedef  IKeySortedSetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySortedSetAsBstTree
                            (INumber = 100);


protected:

           IKeySortedSetAsBstTree
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySortedSetAsBstTree :
  public IGKeySortedSetAsBstTree
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedSetAsBstTree
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedSetImpl
            <IVKeySortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedSetAsBstTreeTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedSetAsBstTreeTypedef (Element, Key, ElementOps);

public:

           IVGKeySortedSetAsBstTree
                            (INumber = 100);


protected:

           IVGKeySortedSetAsBstTree
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySortedSetAsBstTree :
  public IVGKeySortedSetAsBstTree
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedSetAsBstTree
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySortedSetAsBstTree <Element, Key> Self;

#define IVKeySortedSetAsBstTreeTypedef(Element, Key)\
  typedef  IVKeySortedSetAsBstTreeOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySortedSetAsBstTree
                            (INumber = 100);


protected:

           IVKeySortedSetAsBstTree
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <ikssbst.inl>

#pragma info (restore)
#pragma pack ()

#endif
