/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IKSSLST_H
#define _IKSSLST_H

#include <iakss.h>
#include <iickss.h>
#include <iivkss.h>
#include <iiksslst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsList;

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsListCursor :
  public IOrderedCursor <Element> {

  typedef  IOrderedCursor <Element> Inherited;

  typedef  IGKeySortedSetAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGKeySortedSetAsListCursor
                            (IGKeySortedSetAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsListCursor <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGKeySortedSetAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGKeySortedSetAsList :
  public IAKeySortedSet <Element, Key> {
protected:

  typedef  IGKeySortedSetAsList <Element, Key, ElementOps> Self;

  typedef  IKeySortedSetAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICKeySortedSetImpl
            <PureImplementation> Implementation;
#endif

#define IGKeySortedSetAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGKeySortedSetAsListTypedef (Element, Key, ElementOps);

public:

  typedef  IGKeySortedSetAsListCursor
            <Element, Key, ElementOps> Cursor;


           IGKeySortedSetAsList
                            (INumber = 100);

           IGKeySortedSetAsList
                            (IGKeySortedSetAsList
                              <
                               Element, Key, ElementOps> const&);

  IGKeySortedSetAsList <Element, Key, ElementOps>&
           operator=        (IGKeySortedSetAsList
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGKeySortedSetAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGKeySortedSetAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGKeySortedSetAsListCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IKeySortedSetAsList :
  public IGKeySortedSetAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IGKeySortedSetAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IKeySortedSetAsList <Element, Key> Self;

#define IKeySortedSetAsListTypedef(Element, Key)\
  typedef  IKeySortedSetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IKeySortedSetAsList
                            (INumber = 100);


protected:

           IKeySortedSetAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGKeySortedSetAsList :
  public IGKeySortedSetAsList
          <Element, Key, ElementOps > {

  typedef  IVGKeySortedSetAsList
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVKeySortedSetImpl
            <PureImplementation> Implementation;
#else
  typedef  ICKeySortedSetImpl
            <IVKeySortedSetImpl
              <PureImplementation> > Implementation;
#endif

#define IVGKeySortedSetAsListTypedef(Element, Key, ElementOps)\
  typedef  IKeySortedSetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGKeySortedSetAsListTypedef (Element, Key, ElementOps);

public:

           IVGKeySortedSetAsList
                            (INumber = 100);


protected:

           IVGKeySortedSetAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVKeySortedSetAsList :
  public IVGKeySortedSetAsList
          <Element, Key, IKCOps <Element, Key> > {

  typedef  IVGKeySortedSetAsList
            <Element, Key,
             IKCOps <Element, Key> > Inherited;

protected:

  typedef  IVKeySortedSetAsList <Element, Key> Self;

#define IVKeySortedSetAsListTypedef(Element, Key)\
  typedef  IVKeySortedSetAsListOps\
            <Element, Key,\
             IWKCOps <Element, Key, IKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVKeySortedSetAsList
                            (INumber = 100);


protected:

           IVKeySortedSetAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <iksslst.inl>

#pragma info (restore)
#pragma pack ()

#endif
