/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGKeySetAsTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsTableCursor <Element, Key, ElementOps>::
IGKeySetAsTableCursor
  (IGKeySetAsTable
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsTableCursor <Element, Key, ElementOps>&
IGKeySetAsTableCursor <Element, Key, ElementOps>::
operator=
  (IGKeySetAsTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsTableCursor <Element, Key, ElementOps>::
IGKeySetAsTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGKeySetAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsTable <Element, Key, ElementOps>::
IGKeySetAsTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsTable <Element, Key, ElementOps>::
IGKeySetAsTable
  (IGKeySetAsTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsTable <Element, Key, ElementOps>&
IGKeySetAsTable <Element, Key, ElementOps>::
operator= (IGKeySetAsTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGKeySetAsTable <Element, Key, ElementOps>::
IGKeySetAsTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGKeySetAsTable
 <Element, Key, ElementOps>::Implementation&
IGKeySetAsTable <Element, Key, ElementOps>::
ImplOf (IGKeySetAsTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IKeySetAsTable
// ---

// public members

template <class Element, class Key>
inline
IKeySetAsTable <Element, Key>::
IKeySetAsTable (INumber numberOfElements)
: IGKeySetAsTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IKeySetAsTable <Element, Key>::
IKeySetAsTable (PureImplementation& impl)
: IGKeySetAsTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}

// ---
// IVGKeySetAsTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGKeySetAsTable <Element, Key, ElementOps>::
IVGKeySetAsTable (INumber numberOfElements)
: IGKeySetAsTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGKeySetAsTable <Element, Key, ElementOps>::
IVGKeySetAsTable (PureImplementation& impl)
: IGKeySetAsTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVKeySetAsTable
// ---

// public members

template <class Element, class Key>
inline
IVKeySetAsTable <Element, Key>::
IVKeySetAsTable (INumber numberOfElements)
: IVGKeySetAsTable
   <Element, Key, IKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVKeySetAsTable <Element, Key>::
IVKeySetAsTable (PureImplementation& impl)
: IVGKeySetAsTable
   <Element, Key, IKCOps <Element, Key> > (impl)
{
}
