#ifndef _ILBDIEVT_
#define _ILBDIEVT_
/*******************************************************************************
* FILE NAME: ilbdievt.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IListBoxDrawItemEvent                                                    *
*     IListBoxSizeItemEvent                                                    *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <idievt.hpp>

class IListBoxDrawItemHandler;
class ISize;

#pragma pack(4)


class IListBoxDrawItemEvent : public IDrawItemEvent {
typedef IDrawItemEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IListBoxDrawItemEvent ( IEvent& event );

virtual
 ~IListBoxDrawItemEvent ( );

/*--------------------------------- Testing ----------------------------------*/
Boolean
  isSelected ( ) const;

/*----------------------------- Selection State ------------------------------*/
IListBoxDrawItemEvent
 &setSelectionStateDrawn ( Boolean drawn = true );
Boolean
  isSelectionStateDrawn  ( ) const;

private:
/*--------------------------------- Private ----------------------------------*/
friend IListBoxDrawItemHandler;

Boolean
  isDrawItem        ( ) const,
  isSetHighlight    ( ) const,
  isRemoveHighlight ( ) const;

Boolean
  fSelectionStateDrawn;
};  // IListBoxDrawItemEvent


class IListBoxSizeItemEvent : public IControlEvent {
typedef IControlEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IListBoxSizeItemEvent ( IEvent& event );

virtual
 ~IListBoxSizeItemEvent ( );

/*--------------------------- Item Identification ----------------------------*/
unsigned long
  itemIndex ( ) const;

/*------------------------------- Item Sizing --------------------------------*/
IListBoxSizeItemEvent
 &setItemSize ( const ISize& itemSize );
ISize
  itemSize    ( ) const;

private:
/*----------------------------- Hidden Functions -----------------------------*/
IEvent
 &setResult  ( const IEventResult& eventResult );
};  // IListBoxSizeItemEvent


#pragma pack()

#endif /* _ILBDIEVT_ */
