#ifndef _ILBDIHDR_
#define _ILBDIHDR_
/*******************************************************************************
* FILE NAME: ilbdihdr.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IListBoxDrawItemHandler                                                  *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ihandler.hpp>
#include <ibitflag.hpp>
#include <ilbdievt.hpp>

class IListBox;
class ISize;
class IWindow;

#pragma pack(4)


class IListBoxDrawItemHandler : public IHandler {
typedef IHandler
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IListBoxDrawItemHandler ( );

virtual
 ~IListBoxDrawItemHandler ( );

/*---------------------------- Window Attachment -----------------------------*/
virtual IListBoxDrawItemHandler
 &handleEventsFor ( IListBox* listBox ),
 &handleEventsFor ( IWindow*  listBoxOwner );

protected:
/*------------------------------ Event Handling ------------------------------*/
virtual Boolean
  dispatchHandlerEvent ( IEvent&                event );

virtual Boolean
  setItemSize          ( IListBoxSizeItemEvent& event );

virtual Boolean
  drawItem             ( IListBoxDrawItemEvent& event ),
  selectItem           ( IListBoxDrawItemEvent& event ),
  deselectItem         ( IListBoxDrawItemEvent& event );

}; // IListBoxDrawItemHandler


#pragma pack()

#endif /* _ILBDIHDR_ */
