#ifndef _ILISTBOX_
  #define _ILISTBOX_
/*******************************************************************************
* FILE NAME: ilistbox.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IListBox                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ilistbas.hpp>
#include <icontrol.hpp>
#include <irect.hpp>

class IString;
class IResourceId;
class IListBoxData;

#pragma pack(4)

class IListBox : public IBaseListBox {
typedef IBaseListBox
  Inherited;

public:

typedef IBaseListBox::Cursor
  Cursor;

class Style;

/*------------------------- Constructors -------------------------------------*/
  IListBox          ( unsigned             long id,
                      IWindow*             parent,
                      IWindow*             owner,
                      const IRectangle&    initial = IRectangle  ( ),
                      const Style&         style   = defaultStyle( ) );

  IListBox          ( unsigned long        id,
                      IWindow*             parent );

  IListBox          ( const IWindowHandle& handle );

virtual
  ~IListBox         ( );

/*------------------------- Styles -------------------------------------------*/
INESTEDBITFLAGCLASSDEF3(Style, IListBox, IWindow, IControl, IBaseListBox);

static const Style
  IC_IMPORTU classDefaultStyle;

static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&        style );

/*------------------------ Remove and Replace Items --------------------------*/
virtual IListBox
 &removeAt          ( Cursor&             cursor ),
 &removeAll         ( ),
 &replaceAt         ( const char*         item,
                      const Cursor&       cursor ),
 &replaceAt         ( const IResourceId&  text,
                      const Cursor&       cursor);
virtual unsigned long
  remove            ( unsigned long       index );


/*------------------------ Add Items -----------------------------------------*/
virtual unsigned long
  add               ( unsigned long       index,
                      const char*         text ),
  add               ( unsigned long       index,
                      const char* const * itemList,
                      unsigned long       count = 1 ),
  addAsFirst        ( const char*         text ),
  addAsLast         ( const char*         text ),
  addAscending      ( const char*         text ),
  addDescending     ( const char*         text ),
  add               ( unsigned long       index,
                      const IResourceId&  item ),
  addAsFirst        ( const IResourceId&  item ),
  addAsLast         ( const IResourceId&  item ),
  addAscending      ( const IResourceId&  item ),
  addDescending     ( const IResourceId&  item );

virtual IListBox
  &add              ( const char*         item,
                      Cursor&             cursor ),
  &add              ( const IResourceId&  text,
                      Cursor&             cursor),
  &addAsFirst       ( const char*         item,
                      Cursor&             cursor),
  &addAsLast        ( const char*         item,
                      Cursor&             cursor),
  &addAsNext        ( const char*         item,
                      Cursor&             cursor ),
  &addAsFirst       ( const IResourceId&  text,
                      Cursor&             cursor ),
  &addAsLast        ( const IResourceId&  text,
                      Cursor&             cursor ),
  &addAsNext        ( const IResourceId&  text,
                      Cursor&             cursor);

/*------------------------- Notification Members -----------------------------*/
static INotificationId const
  IC_IMPORTU addId,
  IC_IMPORTU removeId;

private:
/*------------------------- Hidden Members -----------------------------------*/
  IListBox          ( const IListBox&     listBox );
IListBox
 &operator=         ( const IListBox&     listBox );

/*------------------------- Private ------------------------------------------*/
IListBoxData
 *fListBoxData;

static Style
  currentDefaultStyle;

friend class IBaseListBox::Cursor;

};  // IListBox


INESTEDBITFLAGCLASSFUNCS(Style, IListBox);

#pragma pack()

#endif  /* _ILISTBOX_ */
