#ifndef _ILISTCVW_
  #define _ILISTCVW_
/*******************************************************************************
* FILE NAME: ilistcvw.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     ICollectionViewListBox                                                   *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#include <ilistbas.hpp>
#include <istrgen.hpp>
#include <icolobsv.hpp>
#include <irect.hpp>
#include <inotify.hpp>


class IString;
class IWindowHandle;
template <class Element, class Collection> class ICollectionViewListBoxData;

#pragma implementation("ilistcvw.c")
#pragma define(ISequence <unsigned long > )
#pragma pack(4)


template <class Element, class Collection>
  class ICollectionViewListBox : public IBaseListBox {

typedef IBaseListBox
  Inherited;
#pragma define(ICollectionObserver<Element,ICollectionViewListBox<Element,Collection>,Collection>)

public:
/*------------------------- Constructors -------------------------------------*/
  ICollectionViewListBox ( unsigned long                identifier,
                           IWindow*                     parent,
                           IWindow*                     owner,
                           const IRectangle&            initial = IRectangle( ),
                           const IBaseListBox::Style&   style   =
                              IBaseListBox::defaultStyle( ),
                           const IStringGenerator<Element>& stringGenerator =
                              IStringGenerator<Element>( ) );

  ICollectionViewListBox ( unsigned long                identifier,
                           IWindow*                     parent,
                           const IStringGenerator<Element>& stringGenerator =
                              IStringGenerator<Element>( ) );

  ICollectionViewListBox ( const IWindowHandle&         handle,
                           const IStringGenerator<Element>& stringGenerator =
                              IStringGenerator<Element>( ) );

virtual
 ~ICollectionViewListBox ( );

/*------------------------- Collection ---------------------------------------*/
virtual Collection
 *items                  ( ) const;

virtual ICollectionViewListBox<Element,Collection>
 &setItems               ( Collection* collection );

/*------------------------- String Generator ---------------------------------*/
virtual IStringGenerator<Element>
 &setStringGenerator     ( const IStringGenerator<Element>& stringGenerator );

virtual IStringGenerator<Element>
 &stringGenerator        ( );

/*------------------------- Collection-Reporting Protocol --------------------*/
virtual ICollectionViewListBox<Element,Collection>
 &elementChanged         ( unsigned long   position,
                           const Element&  element  ),
 &elementAdded           ( unsigned long   position,
                           const Element&  element  ),
 &elementDeleted         ( unsigned long   position ),
 &elementsChanged        ( ),
 &collectionReplaced     ( );

/*------------------------- Selection ----------------------------------------*/
static const unsigned long
  noSelection;

virtual ICollectionViewListBox<Element, Collection>
 &select                     ( unsigned long   collectionPosition,
                               Boolean         select = true ),
 &deselect                   ( unsigned long   collectionPosition );

virtual Element
  selectedElement            ( ) const;

virtual unsigned long
  selectedCollectionPosition ( );

virtual ICollectionViewListBox<Element, Collection>
 &selectedElements           ( Collection&     elements );

#ifndef IC_WIN_FLAGNOP
virtual ICollectionViewListBox<Element, Collection>
 &enableExtendedSelect       ( Boolean         extended = true );
#endif

/*------------------------- Notification Members -----------------------------*/
static INotificationId const
  itemChangedId,
  itemsId,
  extendedSelectChangedId;

private:
/*------------------------- Hidden Members -----------------------------------*/
  ICollectionViewListBox
             ( const ICollectionViewListBox< Element, Collection >& source );
ICollectionViewListBox<Element,Collection>
 &operator=  ( const ICollectionViewListBox< Element, Collection >& source );

/*------------------------- Private ------------------------------------------*/
ICollectionViewListBoxData<Element, Collection>
 *fCollectionViewListBoxData;

unsigned long
  insert     ( unsigned long    index,
               const char*      text  ),
  deleteItem ( unsigned long    index );

ICollectionViewListBox<Element, Collection>
 &deleteAll  ( );

}; // ICollectionViewListBox<Element,Collection>

#if ! defined (__TEMPINC__)
#include <ilistcvw.c>
#endif


#pragma pack()

#endif  /*  _ILISTCVW_  */
