/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGMapAsAvlTreeCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMapAsAvlTreeCursor <Element, Key, ElementOps>::
IGMapAsAvlTreeCursor
  (IGMapAsAvlTree
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGMapAsAvlTreeCursor <Element, Key, ElementOps>&
IGMapAsAvlTreeCursor <Element, Key, ElementOps>::
operator=
  (IGMapAsAvlTreeCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMapAsAvlTreeCursor <Element, Key, ElementOps>::
IGMapAsAvlTreeCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGMapAsAvlTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMapAsAvlTree <Element, Key, ElementOps>::
IGMapAsAvlTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGMapAsAvlTree <Element, Key, ElementOps>::
IGMapAsAvlTree
  (IGMapAsAvlTree
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGMapAsAvlTree <Element, Key, ElementOps>&
IGMapAsAvlTree <Element, Key, ElementOps>::
operator= (IGMapAsAvlTree
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMapAsAvlTree <Element, Key, ElementOps>::
IGMapAsAvlTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGMapAsAvlTree
 <Element, Key, ElementOps>::Implementation&
IGMapAsAvlTree <Element, Key, ElementOps>::
ImplOf (IGMapAsAvlTree
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IMapAsAvlTree
// ---

// public members

template <class Element, class Key>
inline
IMapAsAvlTree <Element, Key>::
IMapAsAvlTree (INumber numberOfElements)
: IGMapAsAvlTree
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IMapAsAvlTree <Element, Key>::
IMapAsAvlTree (PureImplementation& impl)
: IGMapAsAvlTree
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGMapAsAvlTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGMapAsAvlTree <Element, Key, ElementOps>::
IVGMapAsAvlTree (INumber numberOfElements)
: IGMapAsAvlTree
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGMapAsAvlTree <Element, Key, ElementOps>::
IVGMapAsAvlTree (PureImplementation& impl)
: IGMapAsAvlTree
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVMapAsAvlTree
// ---

// public members

template <class Element, class Key>
inline
IVMapAsAvlTree <Element, Key>::
IVMapAsAvlTree (INumber numberOfElements)
: IVGMapAsAvlTree
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVMapAsAvlTree <Element, Key>::
IVMapAsAvlTree (PureImplementation& impl)
: IVGMapAsAvlTree
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
