/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGMapAsBstTreeCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMapAsBstTreeCursor <Element, Key, ElementOps>::
IGMapAsBstTreeCursor
  (IGMapAsBstTree
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGMapAsBstTreeCursor <Element, Key, ElementOps>&
IGMapAsBstTreeCursor <Element, Key, ElementOps>::
operator=
  (IGMapAsBstTreeCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMapAsBstTreeCursor <Element, Key, ElementOps>::
IGMapAsBstTreeCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGMapAsBstTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMapAsBstTree <Element, Key, ElementOps>::
IGMapAsBstTree (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGMapAsBstTree <Element, Key, ElementOps>::
IGMapAsBstTree
  (IGMapAsBstTree
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGMapAsBstTree <Element, Key, ElementOps>&
IGMapAsBstTree <Element, Key, ElementOps>::
operator= (IGMapAsBstTree
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMapAsBstTree <Element, Key, ElementOps>::
IGMapAsBstTree (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGMapAsBstTree
 <Element, Key, ElementOps>::Implementation&
IGMapAsBstTree <Element, Key, ElementOps>::
ImplOf (IGMapAsBstTree
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IMapAsBstTree
// ---

// public members

template <class Element, class Key>
inline
IMapAsBstTree <Element, Key>::
IMapAsBstTree (INumber numberOfElements)
: IGMapAsBstTree
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IMapAsBstTree <Element, Key>::
IMapAsBstTree (PureImplementation& impl)
: IGMapAsBstTree
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGMapAsBstTree
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGMapAsBstTree <Element, Key, ElementOps>::
IVGMapAsBstTree (INumber numberOfElements)
: IGMapAsBstTree
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGMapAsBstTree <Element, Key, ElementOps>::
IVGMapAsBstTree (PureImplementation& impl)
: IGMapAsBstTree
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVMapAsBstTree
// ---

// public members

template <class Element, class Key>
inline
IVMapAsBstTree <Element, Key>::
IVMapAsBstTree (INumber numberOfElements)
: IVGMapAsBstTree
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVMapAsBstTree <Element, Key>::
IVMapAsBstTree (PureImplementation& impl)
: IVGMapAsBstTree
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
