/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGMapAsHshTableCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMapAsHshTableCursor <Element, Key, ElementOps>::
IGMapAsHshTableCursor
  (IGMapAsHshTable
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGMapAsHshTableCursor <Element, Key, ElementOps>&
IGMapAsHshTableCursor <Element, Key, ElementOps>::
operator=
  (IGMapAsHshTableCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMapAsHshTableCursor <Element, Key, ElementOps>::
IGMapAsHshTableCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGMapAsHshTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMapAsHshTable <Element, Key, ElementOps>::
IGMapAsHshTable (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGMapAsHshTable <Element, Key, ElementOps>::
IGMapAsHshTable
  (IGMapAsHshTable
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGMapAsHshTable <Element, Key, ElementOps>&
IGMapAsHshTable <Element, Key, ElementOps>::
operator= (IGMapAsHshTable
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMapAsHshTable <Element, Key, ElementOps>::
IGMapAsHshTable (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGMapAsHshTable
 <Element, Key, ElementOps>::Implementation&
IGMapAsHshTable <Element, Key, ElementOps>::
ImplOf (IGMapAsHshTable
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IMapAsHshTable
// ---

// public members

template <class Element, class Key>
inline
IMapAsHshTable <Element, Key>::
IMapAsHshTable (INumber numberOfElements)
: IGMapAsHshTable
   <Element, Key, IEKEHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IMapAsHshTable <Element, Key>::
IMapAsHshTable (PureImplementation& impl)
: IGMapAsHshTable
   <Element, Key, IEKEHOps <Element, Key> > (impl)
{
}

// ---
// IVGMapAsHshTable
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGMapAsHshTable <Element, Key, ElementOps>::
IVGMapAsHshTable (INumber numberOfElements)
: IGMapAsHshTable
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGMapAsHshTable <Element, Key, ElementOps>::
IVGMapAsHshTable (PureImplementation& impl)
: IGMapAsHshTable
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVMapAsHshTable
// ---

// public members

template <class Element, class Key>
inline
IVMapAsHshTable <Element, Key>::
IVMapAsHshTable (INumber numberOfElements)
: IVGMapAsHshTable
   <Element, Key, IEKEHOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVMapAsHshTable <Element, Key>::
IVMapAsHshTable (PureImplementation& impl)
: IVGMapAsHshTable
   <Element, Key, IEKEHOps <Element, Key> > (impl)
{
}
