/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#ifndef _IMAPLST_H
#define _IMAPLST_H

#include <iamap.h>
#include <iicmap.h>
#include <iivmap.h>
#include <iimaplst.h>


#pragma info (nocls, nocnd, nocns, nocnv, noext, nognr, novft)
#pragma pack (4)

#pragma SOMAsDefault (off)

template <class Element, class Key, class ElementOps>
class IGMapAsList;

template <class Element, class Key, class ElementOps>
class IGMapAsListCursor :
  public IElementCursor <Element> {

  typedef  IElementCursor <Element> Inherited;

  typedef  IGMapAsList
            <Element, Key, ElementOps>::
              Implementation::Cursor Implementation;

public:

           IGMapAsListCursor
                            (IGMapAsList
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsListCursor <Element, Key, ElementOps>&
           operator=        (IGMapAsListCursor
                              <
                               Element, Key, ElementOps> const&);

protected:

           IGMapAsListCursor
                            (ICursorImpl*);

private:


};

template <class Element, class Key, class ElementOps>
class IGMapAsList :
  public IAMap <Element, Key> {
protected:

  typedef  IGMapAsList <Element, Key, ElementOps> Self;

  typedef  IMapAsListImpl PureImplementation;

#if defined (INO_CHECKS)
  typedef  PureImplementation Implementation;
#else
  typedef  ICMapImpl
            <PureImplementation> Implementation;
#endif

#define IGMapAsListTypedef(Element, Key, ElementOps)\
  typedef  IMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IGMapAsListTypedef (Element, Key, ElementOps);

public:

  typedef  IGMapAsListCursor
            <Element, Key, ElementOps> Cursor;


           IGMapAsList
                            (INumber = 100);

           IGMapAsList
                            (IGMapAsList
                              <
                               Element, Key, ElementOps> const&);

  IGMapAsList <Element, Key, ElementOps>&
           operator=        (IGMapAsList
                              <
                               Element, Key, ElementOps> const&);


protected:

           IGMapAsList
                            (PureImplementation&);

  static
  Implementation&
           ImplOf           (IGMapAsList
                              <
                               Element, Key, ElementOps> const&);

private:

  friend
  class    IGMapAsListCursor
            <Element, Key, ElementOps>;



};

template <class Element, class Key>
class IMapAsList :
  public IGMapAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IGMapAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IMapAsList <Element, Key> Self;

#define IMapAsListTypedef(Element, Key)\
  typedef  IMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IMapAsList
                            (INumber = 100);


protected:

           IMapAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key, class ElementOps>
class IVGMapAsList :
  public IGMapAsList
          <Element, Key, ElementOps > {

  typedef  IVGMapAsList
            <Element, Key, ElementOps> Inherited;

protected:

#if defined (INO_CHECKS)
  typedef  IVMapImpl
            <PureImplementation> Implementation;
#else
  typedef  ICMapImpl
            <IVMapImpl
              <PureImplementation> > Implementation;
#endif

#define IVGMapAsListTypedef(Element, Key, ElementOps)\
  typedef  IMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, ElementOps>,\
             Implementation> Instantiation

           IVGMapAsListTypedef (Element, Key, ElementOps);

public:

           IVGMapAsList
                            (INumber = 100);


protected:

           IVGMapAsList
                              (PureImplementation&);

private:


};

template <class Element, class Key>
class IVMapAsList :
  public IVGMapAsList
          <Element, Key, IEKCOps <Element, Key> > {

  typedef  IVGMapAsList
            <Element, Key,
             IEKCOps <Element, Key> > Inherited;

protected:

  typedef  IVMapAsList <Element, Key> Self;

#define IVMapAsListTypedef(Element, Key)\
  typedef  IVMapAsListOps\
            <Element, Key,\
             IWEKCOps <Element, Key, IEKCOps <Element, Key> >,\
             Implementation> Instantiation

public:

           IVMapAsList
                            (INumber = 100);


protected:

           IVMapAsList
                              (PureImplementation&);

private:


};

#pragma SOMAsDefault (pop)

#include <imaplst.inl>

#pragma info (restore)
#pragma pack ()

#endif
