/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// ---
// IGMapAsListCursor
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMapAsListCursor <Element, Key, ElementOps>::
IGMapAsListCursor
  (IGMapAsList
    <Element, Key, ElementOps> const& collection)
: IElementCursor <Element>
    (collection.ivImpl->CreateCursor ())
{
}

template <class Element, class Key, class ElementOps>
inline IGMapAsListCursor <Element, Key, ElementOps>&
IGMapAsListCursor <Element, Key, ElementOps>::
operator=
  (IGMapAsListCursor
    <Element, Key, ElementOps> const& cursor)
{ Inherited::operator= (cursor);
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMapAsListCursor <Element, Key, ElementOps>::
IGMapAsListCursor (ICursorImpl* impl)
: IElementCursor <Element> (impl)
{
}

// ---
// IGMapAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IGMapAsList <Element, Key, ElementOps>::
IGMapAsList (INumber numberOfElements)
{ SetImpl ((Implementation*) *new
                Instantiation (numberOfElements));
}

template <class Element, class Key, class ElementOps>
inline
IGMapAsList <Element, Key, ElementOps>::
IGMapAsList
  (IGMapAsList
    <Element, Key, ElementOps> const& collection)
{ CloneImplOf (collection);
}

template <class Element, class Key, class ElementOps>
inline IGMapAsList <Element, Key, ElementOps>&
IGMapAsList <Element, Key, ElementOps>::
operator= (IGMapAsList
            <Element, Key, ElementOps> const& collection)
{ ImplOf (*this).Copy (ImplOf (collection));
  return *this;
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IGMapAsList <Element, Key, ElementOps>::
IGMapAsList (PureImplementation& impl)
{ SetImpl (&impl);
}

template <class Element, class Key, class ElementOps>
inline IGMapAsList
 <Element, Key, ElementOps>::Implementation&
IGMapAsList <Element, Key, ElementOps>::
ImplOf (IGMapAsList
         <Element, Key, ElementOps> const& collection)
{ return *(Implementation*)collection.ivImpl;
}

// ---
// IMapAsList
// ---

// public members

template <class Element, class Key>
inline
IMapAsList <Element, Key>::
IMapAsList (INumber numberOfElements)
: IGMapAsList
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IMapAsList <Element, Key>::
IMapAsList (PureImplementation& impl)
: IGMapAsList
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}

// ---
// IVGMapAsList
// ---

// public members

template <class Element, class Key, class ElementOps>
inline
IVGMapAsList <Element, Key, ElementOps>::
IVGMapAsList (INumber numberOfElements)
: IGMapAsList
    <Element, Key, ElementOps> (*(Implementation*) *new
                Instantiation (numberOfElements))
{
}

// protected members

template <class Element, class Key, class ElementOps>
inline
IVGMapAsList <Element, Key, ElementOps>::
IVGMapAsList (PureImplementation& impl)
: IGMapAsList
    <Element, Key, ElementOps> (impl)
{
}

// ---
// IVMapAsList
// ---

// public members

template <class Element, class Key>
inline
IVMapAsList <Element, Key>::
IVMapAsList (INumber numberOfElements)
: IVGMapAsList
   <Element, Key, IEKCOps <Element, Key> > (numberOfElements)
{
}

// protected members

template <class Element, class Key>
inline
IVMapAsList <Element, Key>::
IVMapAsList (PureImplementation& impl)
: IVGMapAsList
   <Element, Key, IEKCOps <Element, Key> > (impl)
{
}
