#ifndef _IMCELCV_
  #define _IMCELCV_
/*******************************************************************************
* FILE NAME: imcelcv.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMultiCellCanvas                                                         *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <icanvas.hpp>
#include <irect.hpp>

class IColor;
class IMCCvCell;
class IMultiCellCanvasData;
class IRCHeader;
class ISize;

#pragma pack(4)

class IMultiCellCanvas : public ICanvas {
typedef ICanvas
  Inherited;
public:
class Style;

/*------------------------------- Constructors -------------------------------*/
  IMultiCellCanvas ( unsigned long     windowIdentifier,
                     IWindow*          parent,
                     IWindow*          owner,
                     const IRectangle& initialSize = IRectangle(),
                     const Style&      style = defaultStyle() );

virtual
 ~IMultiCellCanvas ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IMultiCellCanvas, ICanvas, IWindow);
static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU spaceAddedToLast,
  IC_IMPORTU dragLines,
  IC_IMPORTU gridLines;
static Style
  defaultStyle      ( );
static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;


/*------------------------------ Cell Contents -------------------------------*/
virtual IMultiCellCanvas
 &addToCell      ( IWindow*      childWindow,
                   unsigned long startingColumn,
                   unsigned long startingRow,
                   unsigned long numberOfColumns = 1,
                   unsigned long numberOfRows = 1 );
virtual IWindow
 *removeFromCell ( IWindow*      childWindow ),
 *removeFromCell ( unsigned long column,
                   unsigned long row );
virtual IWindow
 *windowInCell   ( unsigned long startingColumn,
                   unsigned long startingRow ) const;

/*-------------------------- Row and Column Sizing ---------------------------*/
virtual IMultiCellCanvas
 &setColumnWidth     ( unsigned long column,
                       unsigned long widthInPixels,
                       Boolean       expandable = false ),
 &setRowHeight       ( unsigned long row,
                       unsigned long heightInPixels,
                       Boolean       expandable = false );
unsigned long
  columnWidth        ( unsigned long column ) const,
  rowHeight          ( unsigned long row    ) const;

Boolean
  isColumnExpandable ( unsigned long column ) const,
  isRowExpandable    ( unsigned long row    ) const;

static void
  setDefaultCell     ( const ISize&  widthAndHeight );

static ISize
  defaultCell        ( );

/*--------------------------- Grid and Drag Lines ----------------------------*/
Boolean
  hasDragLines     ( ) const,
  hasGridLines     ( ) const;

virtual IMultiCellCanvas
 &disableDragLines ( ),
 &enableDragLines  ( Boolean enable = true ),
 &disableGridLines ( ),
 &enableGridLines  ( Boolean enable = true );

/*------------------------------ Layout Support ------------------------------*/
virtual IMultiCellCanvas
 &setLayoutDistorted ( unsigned long layoutAttributesOn,
                       unsigned long layoutAttributesOff );

protected:
/*------------------------------ Layout Support ------------------------------*/
virtual IMultiCellCanvas
 &layout ( );

private:
/*------------------------------ Hidden Members ------------------------------*/
  IMultiCellCanvas ( const IMultiCellCanvas& canvas );
IMultiCellCanvas
 &operator=        ( const IMultiCellCanvas& canvas );

/*--------------------------------- Private ----------------------------------*/
friend class IMultiCellCanvasList;
friend class IMultiCellCanvasHandler;
friend class IRowColumnHeaderList;

IMultiCellCanvas
 &pass1                   ( ),
 &pass2                   ( ),
 &pass3                   ( ),
 &pass4                   ( ),
 &computeExpandedRowsCols ( );

static Style
  currentDefaultStyle;

static unsigned long
  ulDefaultWidth,
  ulDefaultHeight;

unsigned long
  fMulti,
  fExpand;


IMultiCellCanvasList
 *pCanvasList;

IRowColumnHeaderList
 *pRowColHeaderList;

IMultiCellCanvasHandler
 *pCanvasHandler;

friend Boolean IRowColHeaderInitializer ( IRCHeader* const& header,
                                          void*             anything );
friend Boolean IMultiCellCanvasDeleter  ( IMCCvCell* const& cell,
                                          void*             anything );
friend Boolean IRowColumnHeaderDeleter  ( IRCHeader* const& header,
                                          void*             anything );

IMultiCellCanvasData
 *fMultiCellCanvasData;

}; // IMultiCellCanvas

INESTEDBITFLAGCLASSFUNCS(Style, IMultiCellCanvas);

#pragma pack()

#endif /* _IMCELCV_ */
