#ifndef _IMEMSTRM_
#define _IMEMSTRM_
/*******************************************************************************
* FILE NAME: imemstrm.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of class(es):                                                  *
*     IMemoryStream                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
* ADDITONAL COPYRIGHTS:                                                        *
*  Copyright (C) 1996, Taligent, Inc. All rights reserved.                     *
*  Copyright (C) 1996, Lotus Development Corporation. All Rights Reserved.     *
*                                                                              *
*                                                                              *
*******************************************************************************/
#include <ibasstrm.hpp>

#pragma pack(4)


class IMemoryStream : public IBaseStream {
typedef IBaseStream
  Inherited;

public:
/*------------------------------- Constructors -------------------------------*/
  IMemoryStream( );
  IMemoryStream( const void*   memory,
                 size_t        byteCount );
virtual
 ~IMemoryStream();

/*------------------------ Random Access -------------------------------------*/
virtual IBaseStream::Position
  position             ( ) const,
  physicalEndOfStream  ( ) const;

virtual IMemoryStream
 &seek                 ( IBaseStream::Position position);

const char
 *buffer();

protected:
/*------------------------ Buffer Management Overrides -----------------------*/
virtual void
  handleWriteBufferFull  ( const void*    source,
                           size_t         byteCount ),
  handleReadBufferEmpty  ( void*          target,
                           size_t         byteCount );
IMemoryStream
 &setPhysicalEndOfStream ( IBaseStream::Position position);

private:
/*------------------------------ Hidden Members ------------------------------*/
  IMemoryStream ( const IMemoryStream& copy);
IMemoryStream
 &operator=     ( const IMemoryStream& copy);

private:
/*----------------------------- Private --------------------------------------*/
char*
  fBuffer;
unsigned long
  fPosition,
  fCapacity;

}; // IMemoryStream


#pragma pack()

#endif  // _IMEMSTRM_
