#ifndef _IMENUEVT_
  #define _IMENUEVT_
/******************************************************************************
* FILE NAME: imenuevt.hpp                                                     *
*                                                                             *
* DESCRIPTION:                                                                *
*    Declaration of the class:                                                *
*      IMenuEvent                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>

class IPoint;
class IMenuItem;
class IMenuHandler;

#pragma pack(4)

class IMenuEvent  : public IEvent {
typedef IEvent
  Inherited;
public:
/*------------------------------- Constructors -------------------------------*/
  IMenuEvent (IEvent& event);
virtual
 ~IMenuEvent ( );

/*---------------------------- Event Information -----------------------------*/
unsigned long
  menuItemId    ( ) const;

IMenuItem
  menuItem      ( ) const;

IPoint
  mousePosition ( ) const;

private:
friend IMenuHandler;
void
 *fPrevMenuParent;
};

#pragma pack()

#endif /* IMENUEVT */
