#ifndef _IMLE_
  #define _IMLE_
/*******************************************************************************
* FILE NAME: imle.hpp                                                          *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMultiLineEdit                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <itextctl.hpp>
#include <irect.hpp>

class IWindowHandle;
class IFont;
class IColor;
class IMultiLineEditData;

#pragma pack(4)

class IMultiLineEdit : public ITextControl {
typedef ITextControl
  Inherited;

public:
class Style;
/*------------------------------ Constructors --------------------------------*/
  IMultiLineEdit ( unsigned long     id,
                   IWindow*          parent,
                   IWindow*          owner,
                   const IRectangle& initial= IRectangle(),
                   const Style&      style = defaultStyle() );

  IMultiLineEdit ( unsigned long     id,
                   IWindow*          parent );

  IMultiLineEdit ( const IWindowHandle& handle );

virtual
 ~IMultiLineEdit ( );

/*---------------------------------- Styles ----------------------------------*/
INESTEDBITFLAGCLASSDEF2(Style, IMultiLineEdit, IWindow, IControl);

static const Style
  IC_IMPORTU classDefaultStyle,
  IC_IMPORTU border,
  IC_IMPORTU readOnly,
  IC_IMPORTU wordWrap,
  IC_IMPORTU horizontalScroll,
  IC_IMPORTU verticalScroll,
  IC_IMPORTU ignoreTab,
#ifndef IC_MOTIFPM_FLAGNOP
  IC_IMPORTU border3D;
#endif

static Style
  defaultStyle      ( );

static void
  setDefaultStyle   ( const Style&    style );

virtual unsigned long
  convertToGUIStyle ( const IBitFlag& style,
                      Boolean         extendedOnly = false ) const;

/*-------------------------------- Change Operations -------------------------*/
virtual IMultiLineEdit
 &setTextChangedFlag    ( Boolean changed=true ),
 &resetTextChangedFlag  ( );
Boolean
  hasTextChanged        ( ) const;

/*-------------------------------- Read-Only Operations ----------------------*/
virtual IMultiLineEdit
  &disableDataUpdate  ( ),
  &enableDataUpdate   ( Boolean update=true );

Boolean
  isWriteable         ( ) const;

/*-------------------------------- Refresh Operations ------------------------*/
virtual IMultiLineEdit
 &enableUpdate        ( Boolean update=true ),
 &disableUpdate       ( );

/*-------------------------------- Text Operations ---------------------------*/
enum EOLFormat {
  cfText,
  noTran,
  MLEFormat
};

virtual IString
  text         ( ) const,
  text         ( unsigned long lineNumber ) const;
unsigned long
  limit        ( ) const;
virtual unsigned long
  textLength   ( ) const;
virtual IMultiLineEdit
  &setText     ( const char* text ),
  &setText     ( const IResourceId& text ),
  &setText     ( const char* buffer,
                 unsigned long bufferSize ),
  &setLimit    ( unsigned long newLimit );

virtual IMultiLineEdit
  &add         ( const char* text,
                 unsigned long textSize=0,
                 EOLFormat type=cfText ),
  &addAsLast   ( const char* text,
                 unsigned long textSize=0,
                 EOLFormat type=cfText ),
  &addAtOffset ( const char* text,
                 unsigned long offset,
                 unsigned long textSize=0,
                 EOLFormat type=cfText );

/*-------------------------------- Import/Export Operations ------------------*/
virtual unsigned long
  importFromFile           ( const char* fileName,
                             EOLFormat type=cfText ),
  exportToFile             ( const char* fileName,
                             EOLFormat type=cfText ),
  exportSelectedTextToFile ( const char* fileName,
                             EOLFormat type=cfText );

/*-------------------------------- Selected Text -----------------------------*/
static const long
  IC_IMPORTU deselect,
  IC_IMPORTU end;
virtual IMultiLineEdit
 &selectRange        ( const IRange& range=IRange(0,end),
                       unsigned long timestamp=0 );
virtual IRange
  selectedRange      ( ) const;
virtual IString
  selectedText       ( ) const;
virtual unsigned long
  selectedTextLength ( ) const;
virtual Boolean
  hasSelectedText    ( ) const;

/*-------------------------------- Clipboard Operations ----------------------*/
virtual IMultiLineEdit
 &cut     ( unsigned long timestamp=0 ),
 &copy    ( unsigned long timestamp=0 ),
 &paste   ( ),
 &clear   ( unsigned long timestamp=0 ),
 &discard ( );

/*-------------------------------- Undo Operations ---------------------------*/
Boolean
  isUndoable ( ) const;
virtual IMultiLineEdit
 &undo       ( );

/*-------------------------------- Delete Text Operation ---------------------*/
virtual IMultiLineEdit
 &removeAll  ( );

/*-------------------------------- Size Operations ---------------------------*/
virtual IMultiLineEdit
 &setEditRegion       ( ),
 &setEditRegion       ( const ISize& sizeEditRegion ),
 &setEditRegionWidth  ( long width ),
 &setEditRegionHeight ( long height );
unsigned long
  editRegionWidth     ( ) const,
  editRegionHeight    ( ) const;

/*-------------------------------- Tab Stop Operation ------------------------*/
virtual IMultiLineEdit
 &setTab              ( unsigned long tabPixelInterval );

/*------------------------- Compound Control Method --------------------------*/

/*---------------------------- Word Wrap Operations --------------------------*/
Boolean
  isWordWrap      ( ) const;
#ifndef IC_WIN_FLAGNOP
virtual IMultiLineEdit
 &enableWordWrap  ( Boolean enable=true ),
 &disableWordWrap ( );
#endif

/*---------------------------------- Colors ----------------------------------*/
#if ( !defined(IC_MOTIF) && !defined(IC_WIN_FLAGNOP) )
virtual IColor
  foregroundColor ( ) const,
  backgroundColor ( ) const;
#endif //!IC_MOTIF and !IC_WIN_FLAGNOP

/*---------------------------------- Fonts -----------------------------------*/

/*-------------------------------- Line Operations ---------------------------*/
virtual IMultiLineEdit
 &addLine               ( const char*   text,
                          unsigned long lineNumber,
                          EOLFormat     type=cfText ),
 &addLineAsLast         ( const char*   text,
                          EOLFormat     type=cfText ),
 &removeLine            ( unsigned long lineNumber ),
 &setCursorLinePosition ( unsigned long lineNumber ),
 &setCursorPosition     ( unsigned long cursorPosition ),
 &setTop                ( unsigned long lineNumber );

unsigned long
  cursorLinePosition ( ) const,
  cursorPosition     ( ) const,
  top                ( ) const,
  numberOfLines      ( ) const,
  visibleLines       ( ) const;

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTU dataUpdateId,
  IC_IMPORTU limitId;

/*----------------------- Observer Notification ------------------------------*/
virtual IMultiLineEdit
 &enableNotification ( Boolean enable = true );


protected:
/*---------------------- Event-Handling Implementation -----------------------*/

/*-------------------------- Drag and Drop Support ---------------------------*/
virtual Boolean
 isDragStarting    ( IEvent &event );


private:
/*------------------------------ Hidden Members ------------------------------*/
  IMultiLineEdit        ( const IMultiLineEdit& multiLineEdit );
IMultiLineEdit
 &operator=             ( const IMultiLineEdit& multiLineEdit );

/*--------------------------------- Private ----------------------------------*/
long
  exportFile            ( const char* fileName,
                          Boolean flMarkedAreaOnly );


unsigned long
  textLengthAfterFormat ( ) const;

static Style
  currentDefaultStyle;

unsigned long
  fcharLimit;
Boolean
  flimitSet;

Boolean
  bRefresh;

IMultiLineEditData
 *fMultiLineEditData;

friend class IMultiLineHandler;
/*---------------------------- Obsolete Members ------------------------------*/
#if (IC_OBSOLETE <= IC_OBSOLETE_2)
public:
virtual IMultiLineEdit
 &setChangedFlag    ( Boolean changed=true ),
 &resetChangedFlag  ( );
Boolean
  isChanged         ( ) const;
#endif
};

INESTEDBITFLAGCLASSFUNCS(Style, IMultiLineEdit);

#pragma pack()

#endif
