#ifndef _IMMAMIX_
   #define _IMMAMIX_
/*******************************************************************************
* FILE NAME: immamix.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the class(es):                                              *
*     IMMAmpMixer                                                              *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <immdev.hpp>
#include <istring.hpp>

#pragma pack(4)


class IMMAmpMixer : public IMMDevice {
typedef IMMDevice
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMAmpMixer  (Boolean openNow = true,
                unsigned long instance = 0, Boolean openShareable = true);
  IMMAmpMixer  (unsigned long deviceIdentifier,
                const IString& newAlias = IString());

virtual
  ~IMMAmpMixer ();

/*----------------------------- Mixer Attributes -----------------------------*/
unsigned long
  balance        (CallType call = wait) const,
  bass           (CallType call = wait) const,
  gain           (CallType call = wait) const,
  pitch          (CallType call = wait) const,
  treble         (CallType call = wait) const;
virtual IMMAmpMixer
  &setBalance    (unsigned long balance, CallType call = wait),
  &setBass       (unsigned long bass, CallType call = wait),
  &setGain       (unsigned long gain, CallType call = wait),
  &setPitch      (unsigned long pitch, CallType call = wait),
  &setTreble     (unsigned long treble, CallType call = wait);

/*----------------------------- Monitoring -----------------------------------*/
virtual IMMAmpMixer
  &enableMonitoring   (Boolean enable= true, CallType call = wait),
  &disableMonitoring  (CallType call = wait);
Boolean
  isMonitoringEnabled (CallType call = wait) const;

/*-------------------------- Device open/close overrides ---------------------*/
virtual IMMAmpMixer
  &open              (const IString& fileOrDevice = IString(),
                      Boolean shareable = true,
                      CallType call = wait),
  &openOnThread      (const IString& fileOrDevice = IString(),
                      Boolean shareable = true,
                      CallType call = wait);
virtual IMMAmpMixer
  &close             (CallType call = wait);

protected:
/*-------------------------------- Implementaion -----------------------------*/
virtual Boolean
  isOpenStringValid(const IString& deviceName) const;

/*-------------------------- Device open overrides ---------------------------*/
virtual IMMAmpMixer
  &open                   (unsigned long instanceNumber,
                           Boolean shareable = true,
                           CallType call = nowait),
  &openOnThread           (unsigned long instanceNumber,
                           Boolean shareable = true);
}; // IMMAmpMixer


#pragma pack()

#endif /* _IMMAMIX_ */
