#ifndef _IMMCDDA_
   #define _IMMCDDA_
/*******************************************************************************
* FILE NAME: immcdda.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMAudioCD                                                               *
*     IMMAudioCDContents                                                       *
*     IMMAudioCDContents::Cursor                                               *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <immremed.hpp>
#include <iprofile.hpp>
#include <immtime.hpp>
#include <istring.hpp>
#include <inotify.hpp>
#include <immttime.hpp>

class IMMTMSFTime;
class ITimer;
class IMMCursorData;
class IMMAudioCDContentsData;
class IMMAudioCDData;

#pragma pack(4)


class IMMAudioCDContents : public IVBase {

typedef IVBase
  Inherited;

public:
/*----------------------------- Constructors ---------------------------------*/
  IMMAudioCDContents ( const IMMAudioCDContents& newToc);

virtual ~IMMAudioCDContents();

IMMAudioCDContents
  &operator =        (const IMMAudioCDContents& newContents);

class Cursor : public IVBase {
public:
/*----------------------------- Constructors --------------------------------*/
  Cursor        ();

  Cursor        (const IMMAudioCDContents& contents);

  Cursor        (const Cursor& cursor);

virtual ~Cursor ();

Cursor
  &operator =   (const Cursor& newCursor);

/*--------------- Cursor Validation and Cursor Movement ----------------------*/
virtual Cursor
  &invalidate(),
  &setToFirst(),
  &setToNext(),
  &setToPrevious(),
  &setToLast(),
  &setToIndex(unsigned long toIndex),
  &operator ++(),
  &operator --();

unsigned long
  asIndex() const;

Boolean
  isValid() const;


private:
friend class IMMAudioCDContents;

IMMCursorData*
  fCursorData;
}; // IMMAudioCDContents::Cursor

/*----------------------------- Track Information ----------------------------*/
unsigned long
  controlInformation (const Cursor& cursor) const,
  country            (const Cursor& cursor) const,
  owner              (const Cursor& cursor) const,
  serialNumber       (const Cursor& cursor) const,
  track              (const Cursor& cursor) const,
  numberOfTracks     () const;

IString
  discId             () const;

Boolean
  isValid            () const;

IMMTime
  endOfTrack         (const Cursor& cursor) const,
  startOfTrack       (const Cursor& cursor) const;

/*----------------------------- Entry Information ----------------------------*/
unsigned long
  numberOfEntries    () const;
IMMAudioCDContents
  &addEntryAsFirst   (unsigned long trackNumber),
  &addEntryAsNext    (unsigned long trackNumber,
                      const Cursor& cursor),
  &replaceEntryAt    (unsigned long newTrackNumber,
                      const Cursor& cursor),
  &removeEntryAt     (const Cursor& cursor);

protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMAudioCDContents ( void* newContents,
                       const IString& identifier,
                       unsigned long tracks );
  IMMAudioCDContents ();

private:
/*--------------------------------- Private ----------------------------------*/
friend class IMMAudioCDContents::Cursor;
friend class IMMAudioCD;
friend class IMMTrackMinSecFrameTime;
IMMTime
  timeAt(unsigned long track,Boolean begin) const;

IMMAudioCDContentsData*
  fContentsData;
}; // IMMAudioCDContents


class IMMAudioCD : public IMMRemovableMedia {

typedef IMMRemovableMedia
  Inherited;

public:
/*----------------------------- Constructors ---------------------------------*/
  IMMAudioCD  ( IProfile* profile       = 0,
                Boolean openNow         = true,
                unsigned long instance  = 0,
                Boolean openShareable   = true);
virtual
  ~IMMAudioCD ();

/*-------------------------------- Compact Disc Information ------------------*/
static const IString
  IC_IMPORTM discTitleKey,
  IC_IMPORTM discProgramKey;

unsigned long
  numberOfTracks          (CallType call = wait) const,
  currentTrack            () const ;

Boolean
  isAutoPlayEnabled       () const,
  isContinuousPlayEnabled () const;

IString
  discId                  (CallType call = wait) const,
  upc                     (CallType call = wait) const,
  trackTitle              (unsigned long track) const,
  discTitle               () const;

IMMAudioCD
  &enableContinuousPlay   (Boolean continuousPlay = true),
  &disableContinuousPlay  (),
  &enableAutoPlay         (Boolean autoPlay = true),
  &disableAutoPlay        (),
  &setDiscTitle           (const IString& title),
  &setTrackTitle          (const IString& title,
                           unsigned long track);

/*-------------------------------- Profile -----------------------------------*/
IProfile
  profile              () const;

IMMAudioCDContents
  contents             () const;
unsigned long
  currentContentsEntry () const ;

IMMAudioCD
  &setProfile          (IProfile& profile),
  &setProgram          (const IMMAudioCDContents& program);

/*-------------------------------- Play, Stop, and Scan ----------------------*/
virtual IMMAudioCD
  &pause               (CallType call = wait),
  &play                (const IMMTime& from = IMMTime(),
                        const IMMTime& to   = IMMTime(),
                        Boolean resumeIfPaused = true,
                        CallType call = nowait),
  &stop                (CallType call = wait),
  &resume              (Boolean resume = true, CallType call = wait),
  &goToEntry           (unsigned long index),
  &goToEntry           (IMMAudioCDContents::Cursor cursor);

IMMAudioCD
  &trackBackward       (unsigned long decrement = 1),
  &trackForward        (unsigned long increment = 1),
  &startScanningForward(),
  &startScanningBackward();

/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTM positionTimerId,
  IC_IMPORTM trackStartedId;

/*----------------------------- Audio Overrides -----------------------------*/
virtual IMMAudioCD
  &setVolume   (unsigned long volume,
                AudioChannel channel = all,
                const IMMMillisecondTime& over = IMMMillisecondTime(),
                CallType call = wait);
virtual unsigned long
  volume       (AudioChannel channel = left,
                CallType call = wait) const;

protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMAudioCD ( unsigned long deviceIdentifier,
               const IString& newAlias = IString() );

virtual Boolean
  isOpenStringValid  (const IString& deviceName) const;

virtual IString
  uniqueDiscIdentifier () const;

/*----------------------------- Table ----------------------------------------*/
IMMAudioCDContents
  getTableFromDisc   ();

private:
/*--------------------------------- Private ----------------------------------*/
IMMAudioCD
  &setTableOfContents (const IMMAudioCDContents& newContents),
  &stopT              (),
  &processInternal    (const IMMNotifyEvent &evt);
Boolean
  moveOneTrack        (Boolean forward, unsigned long number),
  goToCursor          (),
  playing             ();
void
  putInPlayingState   (),
  putInStoppedState   (),
  changeTable         (),
  handleScan          (unsigned long id),
  handleUpdate        (unsigned long id);

enum ScanStatus
{
  notScanning,
  scanningForward,
  scanningBackward
};

IMMAudioCDData*
  fAudioCDData;

Boolean
  fDelay;

friend class IMMAudioCDData;
friend class IMMAudioCDHandler;
}; // IMMAudioCD


#pragma pack()

#endif /* _IMMCDDA_ */
