#ifndef _IMMDIGVD_
   #define _IMMDIGVD_
/*******************************************************************************
* FILE NAME:  immdigvd.hpp                                                     *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMDigitalVideo                                                          *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <immaud.hpp>
#include <istring.hpp>
#include <irect.hpp>

class IMMSpeed;
class IWindowHandle;
class IWindow;
class IMMDeviceSettings;

#pragma pack(4)


class IMMDigitalVideo : public IMMConfigurableAudio {
typedef IMMConfigurableAudio
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMDigitalVideo  ( Boolean       openNow = true,
                     unsigned long instance = 0,
                     Boolean       openShareable = true );
virtual
 ~IMMDigitalVideo ();

/*-------------------------------- Playback Speeds ---------------------------*/
IMMSpeed
  maximumSpeed      (CallType call = wait) const,
  minimumSpeed      (CallType call = wait) const,
  normalSpeed       (CallType call = wait) const,
  speed             (CallType call = wait) const,
  fileNormalSpeed   (CallType call = wait) const;

/*-------------------------------- Capabilities ------------------------------*/
Boolean
  supportsSizing          (CallType call = wait) const,
  supportsReverse         (CallType call = wait) const,
  supportsStretchToFit    (CallType call = wait) const,
  supportsOverlayGraphics (CallType call = wait) const;

/*-------------------------- Playback ----------------------------------------*/
Boolean
  isPlayingForward (CallType call = wait) const;

virtual IMMDigitalVideo
 &play            ( const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    Boolean resumeIfPaused = true,
                    CallType call = nowait );

IMMDigitalVideo
 &playAt          ( const IMMSpeed& speed,
                    const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = nowait ),
 &playFast        ( const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = nowait ),
 &playScan        ( const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = nowait ),
 &playSlow        ( const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = nowait );

/*-------------------------- Record and Monitoring ---------------------------*/
virtual IMMDigitalVideo
 &record              ( const IMMTime& end   = IMMTime(),
                        Boolean resumeIfPaused = true,
                        CallType call = nowait );

/*-------------------------- Video Window ------------------------------------*/
unsigned long
  videoWidth         ( CallType call = wait ) const,
  videoHeight        ( CallType call = wait ) const;
unsigned long
  maximumWindows     ( CallType call = wait ) const ;
unsigned long
  videoFileWidth     ( CallType call = wait ) const,
  videoFileHeight    ( CallType call = wait ) const;

IRectangle
  sourceRectangle    ( CallType call = wait ) const,
  destinationRectangle(CallType call = wait ) const;

IMMDigitalVideo
 &setDestination     ( const IRectangle& rectangle, CallType call = wait ),
 &setWindow          ( const IWindowHandle& handle, CallType call = wait ),
 &setWindow          ( const IWindow& window, CallType call = wait ),
 &useDefaultWindow   ( CallType call = wait );


IWindowHandle
  handle             ( CallType call = wait ) const;
IString
  videoFileName      () const;


protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMDigitalVideo ( unsigned long deviceIdentifier,
                    const IString& newAlias );

/*-------------------------------- Implementation ----------------------------*/
IMMDigitalVideo
 &playDigital        ( const IMMTime& from = IMMTime(),
                       const IMMTime& to   = IMMTime(),
                       CallType call = nowait,
                       unsigned long flags = 0,
                       unsigned long speed = 0 );

virtual Boolean
  isOpenStringValid  ( const IString& deviceName ) const;

virtual IMMDigitalVideo
 &saveDeviceSettings     (),
 &restoreDeviceSettings  ( Boolean newRecordMode = false );

private:
/*--------------------------------- Private ----------------------------------*/

/*--------------------------------- Hidden Functions--------------------------*/
  IMMDigitalVideo       ( const IMMDigitalVideo& device );
IMMDigitalVideo
 &operator=             ( const IMMDigitalVideo& device );
virtual IMMDigitalVideo
 &record          ( Boolean insert ,
                    const IMMTime& begin,
                    const IMMTime& end,
                    Boolean resumeIfPaused,
                    CallType call = nowait );
IMMDigitalVideo
 &setSpeed        ( const unsigned long speed = 1000 );
unsigned long
  getSpeedFactor  ( const IMMSpeed speed ) const;
IMMDeviceSettings
 *fDeviceSettings;

}; // IMMDigitalVideo


#pragma pack()

#endif /* _IMMDIGVD_ */
