#ifndef _IMMEVT_
   #define _IMMEVT_
/*******************************************************************************
* FILE NAME:  immevt.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMNotifyEvent                                                           *
*     IMMPassDeviceEvent                                                       *
*     IMMPositionChangeEvent                                                   *
*     IMMCuePointEvent                                                         *
*     IMMDeviceEvent                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ievent.hpp>

class IString;
class IMMTime;
class IMMDevice;

#pragma pack(4)


class IMMNotifyEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMNotifyEvent  (const IEvent& event);

virtual
  ~IMMNotifyEvent ();

/*-------------------------------- Command -----------------------------------*/
enum Command
{
  unknownCommand = 0,
  open = 1,
  close,
  escape,
  play,
  seek,
  stop,
  pause,
  info,
  getDeviceCapabilities,
  status,
  spin,
  set,
  step,
  record,
  sysInfo,
  save,
  cue,
  update,
  setCuePoint,
  setPositionAdvise,
  setSyncOffset,
  load,
  acquireDevice,
  releaseDevice,
  masterAudio,
  getTableOfContents,
  deviceSettings,
  connector,
  resume,
  connectorInfo,
  defaultConnection,
  connection,
  group,
  capture = 40,
  freeze,
  getImageBuffer,
  getImagePalette,
  put,
  realize,
  rewind,
  restore,
  setImageBuffer,
  setImagePalette,
  unfreeze,
  where,
  windowCommand,
  deleteCommand,
  cut,
  paste,
  copy,
  redo,
  undo,
// Win32 MCI specific commands
  breakCommand,
  monitor,
  reserve,
  setAudioCommand,
  signal,
  setVideoCommand,
  qualityCommand,
  listCommand,
  configureCommand
};

Command
  command() const;

/*----------------------------- Success Code ---------------------------------*/
enum SuccessCode
{
  successful,
  preempted,
  aborted,
  error
};

SuccessCode
  successCode         () const;

/*----------------------------- Event Parsing Members ------------------------*/
IMMDevice
  *device             () const;
unsigned short
  errorId             () const,
  userParameter       () const;

static IString
  errorText           (unsigned long errorCode);

}; // IMMNotifyEvent


class IMMPassDeviceEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMPassDeviceEvent  (const IEvent& event);
virtual
  ~IMMPassDeviceEvent ();

/*----------------------------- Event Parsing Members ------------------------*/
IMMDevice
  *device    () const;

Boolean
  isGainingUse () const;
}; // IMMPassDeviceEvent

class IMMPositionChangeEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMPositionChangeEvent  (const IEvent& event);
virtual
  ~IMMPositionChangeEvent ();

/*----------------------------- Event Parsing Members ------------------------*/
IMMDevice
  *device       () const;
unsigned short
  userParameter () const;
IMMTime
  position      () const;
}; // IMMPositionChangeEvent

class IMMCuePointEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMCuePointEvent  (const IEvent& event);
virtual
  ~IMMCuePointEvent ();

/*----------------------------- Event Parsing Members ------------------------*/
IMMDevice
  *device       () const;
unsigned short
  userParameter () const;
IMMTime
  position      () const;
}; // IMMCuePointEvent


class IMMDeviceEvent : public IEvent {
typedef IEvent
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMDeviceEvent  (const IEvent& event);
virtual
  ~IMMDeviceEvent ();

/*----------------------------- Event Parsing Members ------------------------*/
IMMDevice
  *device    () const;
unsigned short
  eventCode  () const;
void
  *eventData () const;
}; // IMMDeviceEvent


#pragma pack()

#endif /* _IMMEVT_ */
