#ifndef _IMMMAUD_
   #define _IMMMAUD_
/*******************************************************************************
* FILE NAME: immmaud.hpp                                                       *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMMasterAudio                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <istdntfy.hpp>
#include <immdev.hpp>

class IMMMasterAudioData;

#pragma pack(4)


class IMMMasterAudio : public IStandardNotifier {
typedef IStandardNotifier
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMMasterAudio  ();

virtual
  ~IMMMasterAudio ();

/*-------------------------------- Setting Source ----------------------------*/
enum SettingSource
{
  saved   = 0x00004000L,
  current = 0x00008000L
};

/*----------------------------- Speakers -------------------------------------*/
virtual IMMMasterAudio
  &enableSpeakers      (Boolean enable = true, IMMDevice::CallType call = IMMDevice::wait),
  &disableSpeakers     (IMMDevice::CallType call = IMMDevice::wait),
  &saveSpeakersSetting (IMMDevice::CallType call = IMMDevice::wait);
Boolean
  areSpeakersEnabled   (SettingSource source = current,
                        IMMDevice::CallType call = IMMDevice::wait) const;

/*----------------------------- Headphones -----------------------------------*/
virtual IMMMasterAudio
  &enableHeadphones      (Boolean enable = true, IMMDevice::CallType call = IMMDevice::wait),
  &disableHeadphones     (IMMDevice::CallType call = IMMDevice::wait),
  &saveHeadphonesSetting (IMMDevice::CallType call = IMMDevice::wait);
Boolean
  areHeadphonesEnabled (SettingSource source = current,
                        IMMDevice::CallType call = IMMDevice::wait) const;

/*----------------------------- Volume ---------------------------------------*/
virtual IMMMasterAudio
  &setVolume  (unsigned long volume , IMMDevice::CallType call = IMMDevice::wait),
  &saveVolume (IMMDevice::CallType call = IMMDevice::wait);
unsigned long
  volume      (SettingSource source = current,
               IMMDevice::CallType call = IMMDevice::wait) const;
private:
/*--------------------------------- Private ----------------------------------*/
IMMMasterAudioData*
  fMasterAudioData;
}; // IMMMasterAudio


#pragma pack()

#endif /* _IMMMAUD_ */
