#ifndef _IMMPLYPN_
   #define _IMMPLYPN_
/*******************************************************************************
* FILE NAME: immplypn.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMPlayerPanel                                                           *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <imcelcv.hpp>
#include <immplayd.hpp>

class IMMPlayerPanelData;
class IMMPlayerPanelHandler;
class IAnimatedButton ;

#pragma pack(4)


class IMMPlayerPanel : public IMultiCellCanvas {
typedef IMultiCellCanvas
  Inherited;
public:
/*------------------------- Constructors -------------------------------------*/
  IMMPlayerPanel  ( unsigned long         identifier,
                    IWindow*              parent,
                    IWindow*              owner,
                    unsigned long         deviceType = IMMDevice::other,
                    const IRectangle&     initial = IRectangle(),
                    const IMultiCellCanvas::Style& style =
                                    IMultiCellCanvas::defaultStyle() );

virtual
  ~IMMPlayerPanel ();

/*-------------------------------- Device ------------------------------------*/
IMMPlayableDevice*
  playableDevice     () const;
IMMPlayerPanel
  &setPlayableDevice (IMMPlayableDevice* device);
unsigned long
  deviceType         () const;

/*-------------------------------- Buttons -----------------------------------*/
IAnimatedButton
  *rewindButton       () const,
  *fastForwardButton  () const,
  *pauseButton        () const,
  *stopButton         () const,
  *playButton         () const,
  *stepForwardButton  () const,
  *stepBackwardButton () const;

private:
/*--------------------------------- Private ----------------------------------*/

/*--------------------------------- Hidden Functions--------------------------*/
  IMMPlayerPanel        ( const IMMPlayerPanel& panel );
IMMPlayerPanel
 &operator=             ( const IMMPlayerPanel& panel );

IMMPlayerPanelData
  *fPanelData;
}; // IMMPlayerPanel


#pragma pack()

#endif /* _IMMPLYPN_ */
