#ifndef _IMMRECRD_
   #define _IMMRECRD_
/*******************************************************************************
* FILE NAME:  immrecrd.hpp                                                     *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMRecordable                                                            *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <immfilem.hpp>
#include <immtime.hpp>
#include <istring.hpp>

class IMMDeviceSettings;

#pragma pack(4)


class IMMRecordable : public IMMFileMedia {
typedef IMMFileMedia
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
virtual
  ~IMMRecordable();

/*-------------------------------- Editing -----------------------------------*/
virtual IMMRecordable
  &copy            (const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = wait) const,
  &cueForRecording (CallType call = nowait),
  &cut             (const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = wait),
  &deleteSelection (const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    CallType call = wait),
  &paste           (const IMMTime& from = IMMTime(),
                    const IMMTime& to   = IMMTime(),
                    Boolean convert = true,
                    CallType call = wait),
  &record          (Boolean insert = true,
                    const IMMTime& begin = IMMTime(),
                    const IMMTime& end   = IMMTime(),
                    Boolean resumeIfPaused = true,
                    CallType call = nowait),
  &save            (CallType call = nowait),
  &saveAs          (const IString& filename, CallType call = nowait);


protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMRecordable ( const IString& deviceName,
                  Boolean openNow,
                  unsigned long instance,
                  Boolean openShareable);

  IMMRecordable ( unsigned long deviceIdentifier,
                  const IString& newAlias = IString());

/*-------------------------------- Implementation ----------------------------*/
virtual IMMRecordable
  &saveDeviceSettings     (),
  &restoreDeviceSettings  (Boolean newRecordMode = false);

private:
/*--------------------------------- Private ----------------------------------*/

/*--------------------------------- Hidden Functions--------------------------*/
  IMMRecordable         ( const IMMRecordable& device );
IMMRecordable
 &operator=             ( const IMMRecordable& device );

IMMDeviceSettings
  *fDeviceSettings ;

}; // IMMRecordable


#pragma pack()

#endif /* _IMMRECRD_ */
