#ifndef _IMMREMED_
   #define _IMMREMED_
/*******************************************************************************
* FILE NAME:  immremed.hpp                                                     *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMRemovableMedia                                                        *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <immplayd.hpp>
#include <istring.hpp>
#include <inotify.hpp>

class IMMRemovableMediaHandler;
class IMMRemovableMediaNotifyHandler;
class IMMRemovableMediaData;

#pragma pack(4)


class IMMRemovableMedia : public IMMPlayableDevice {
typedef IMMPlayableDevice
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
virtual
  ~IMMRemovableMedia();

/*-------------------------------- Door and Presence -------------------------*/
virtual IMMRemovableMedia
  &closeDoor     (CallType call = wait),
  &openDoor      (Boolean open = true, CallType call = wait);

Boolean
  isMediaPresent (CallType call = wait) const;


/*----------------------- Notification Event Descriptions --------------------*/
static INotificationId const
  IC_IMPORTM mediaLoadedId;

/*----------------------- Observer Notification ------------------------------*/
virtual IMMRemovableMedia
 &enableNotification (Boolean enabled = true);

protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMRemovableMedia (const IString& deviceName,
                      Boolean openNow,
                      unsigned long instance,
                      Boolean openShareable);

  IMMRemovableMedia (unsigned long deviceIdentifier,
                      const IString& newAlias = IString());

/*------------------- Observer Notification Implementation -------------------*/
IMMRemovableMedia
 &setNotificationHandler ( IMMRemovableMediaNotifyHandler* notifyHandler );

IMMRemovableMediaNotifyHandler
 *notificationHandler    ( ) const;


private:
/*--------------------------------- Private ----------------------------------*/
friend class IMMRemovableMediaHandler;

IMMRemovableMedia                         //aj: very platform-specific, private hides them better than protected
  &startCheckMediaTimer(),
  &stopCheckMediaTimer();
void                                      //aj
  checkMedia      (unsigned long timerId);

IMMRemovableMediaData
  *fRemovableMediaData;


}; // IMMRemvableMedia


#pragma pack()

#endif /* _IMMREMED_ */
