#ifndef _IMMSEQU_
   #define _IMMSEQU_
/*******************************************************************************
* FILE NAME:  immsequ.hpp                                                      *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMSequencer                                                             *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <immfilem.hpp>
#include <istring.hpp>

class IMMDeviceSettings;

#pragma pack(4)


class IMMSequencer : public IMMFileMedia {
typedef IMMFileMedia
  Inherited;
public:
/*----------------------------- Constructors ---------------------------------*/
  IMMSequencer  ( Boolean openNow = true,
                  unsigned long instance = 0,
                  Boolean openShareable = true );
virtual
  ~IMMSequencer ();

/*----------------------------- Audio Overrides -----------------------------*/
virtual IMMSequencer
  &setVolume   (unsigned long volume,
                AudioChannel channel = all,
                const IMMMillisecondTime& over = IMMMillisecondTime(),
                CallType call = wait);
virtual unsigned long
  volume       (AudioChannel channel = left,
                CallType call = wait) const;
virtual IMMSequencer
  &resume      (Boolean resume = true, CallType call = wait);

protected:
/*----------------------------- Constructors ---------------------------------*/
  IMMSequencer(unsigned long deviceIdentifier,
               const IString& newAlias = IString());

/*-------------------------------- Implementation ----------------------------*/
virtual Boolean
  isOpenStringValid(const IString& deviceName) const;

virtual IMMSequencer
  &saveDeviceSettings     (),
  &restoreDeviceSettings  (Boolean newRecordMode = false);

private:
/*--------------------------------- Private ----------------------------------*/

/*--------------------------------- Hidden Functions--------------------------*/
  IMMSequencer          ( const IMMSequencer& device );
IMMSequencer
 &operator=             ( const IMMSequencer& device );

IMMDeviceSettings
  *fDeviceSettings ;

}; // IMMSequencer


#pragma pack()

#endif /* _IMMSEQU_ */
