#ifndef _IMMSPEED_
   #define _IMMSPEED_
/*******************************************************************************
* FILE NAME:  immspeed.hpp                                                     *
*                                                                              *
* DESCRIPTION:                                                                 *
*   Declaration of the classes:                                                *
*     IMMSpeed                                                                 *
*                                                                              *
* COPYRIGHT:                                                                   *
*   IBM Open Class Library                                                     *
*   (C) Copyright International Business Machines Corporation 1992, 1996       *
*   Licensed Material - Program-Property of IBM - All Rights Reserved.         *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/
#include <ivbase.hpp>

#pragma pack(4)


class IMMSpeed : public IVBase {
typedef IVBase
  Inherited;
public:
enum Format
{
  percentage      = 3,
  framesPerSecond
};

/*----------------------------- Constructors ---------------------------------*/
  IMMSpeed  ( unsigned long percent = 100 );
  IMMSpeed  ( Format format,
              unsigned long speed );
virtual
  ~IMMSpeed ();

/*-------------------------------- Format ------------------------------------*/
Format
  format () const;
virtual unsigned long
  speed  () const;

private:
/*--------------------------------- Private ----------------------------------*/
Format
  fFormat;
unsigned long
  fSpeed;
}; // IMMSpeed


#pragma pack()

#endif /* _IMMSPEED_ */
